% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildEdgeMatrix.R
\name{buildEdgeMatrix}
\alias{buildEdgeMatrix}
\alias{as.dist.edgematrix}
\title{Build an nearest-neighbor graph weighted by distance.}
\usage{
buildEdgeMatrix(data, neighbors = NULL, distance_method = "Euclidean",
  threads = NULL, verbose = getOption("verbose", TRUE), ...)

\method{as.dist}{edgematrix}(m, diag = FALSE, upper = FALSE)
}
\arguments{
\item{data}{A matrix with a number of columns equal to the number of columns in `x`}

\item{neighbors}{An adjacency matrix of the type produced by \code{\link{randomProjectionTreeSearch}}. If \code{NULL}, \code{\link{randomProjectionTreeSearch}}
will be run with parameters given by \code{...}.}

\item{distance_method}{One of "Euclidean" or "Cosine"}

\item{threads}{The number of threads to use in calculating distance; set automatically if \code{NULL} (the default).}

\item{verbose}{Verbosity}

\item{...}{Additional parameters passed to \code{\link{randomProjectionTreeSearch}} if \code{neighbors} is \code{NULL}.}

\item{m}{An `edgematrix` object.}

\item{diag}{logical value indicating whether the diagonal of the distance matrix should be printed by print.dist.}

\item{upper}{logical value indicating whether the upper triangle of the distance matrix should be printed by print.dist.}
}
\value{
An `edgematrix` object consisting of the elements of a sparse matrix, with the distance method stored in attribute \code{method}.

A \code{\link[stats]{dist}} object.
}
\description{
Build an nearest-neighbor graph weighted by distance.

Convert an edge matrix to a \code{dist} object.
}
\note{
This method converts the otherwise sparse edge matrix into a dense \code{dist} object,
where any distances absent from the edge matrix are represented as \code{NA}.
}
