% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operatorOverload.R
\name{$.largeList}
\alias{$.largeList}
\title{Overload of operator $.}
\usage{
\method{$}{largeList}(x, index)
}
\arguments{
\item{x}{A largeList object created by \code{\link{getList}}.}

\item{index}{A character vector of length 1.}
}
\value{
A R object.
}
\description{
Overload of operator $.
}
\details{
It behaviours different from the list object in R. Here \code{x$name} is equivalent to
\code{x[["name"]]}, \strong{no partial matching}.
}
\examples{
largelist_object <- getList("example.llo", truncate = TRUE)
largelist_object[[]] <- list("AA" = 1, "B" = 2, "C" = 3)  ## assign list to the list file
largelist_object$B ## get 2
largelist_object$A ## get NULL, not 1 from "AA" since no partial matching happens.
}
\seealso{
\code{\link{[[.largeList}} \code{\link{largeList}}
}
