% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_factor.R
\name{to_factor}
\alias{to_factor}
\alias{to_factor.haven_labelled}
\alias{to_factor.data.frame}
\alias{unlabelled}
\title{Convert input to a factor.}
\usage{
to_factor(x, ...)

\method{to_factor}{haven_labelled}(
  x,
  levels = c("labels", "values", "prefixed"),
  ordered = FALSE,
  nolabel_to_na = FALSE,
  sort_levels = c("auto", "none", "labels", "values"),
  decreasing = FALSE,
  drop_unused_labels = FALSE,
  user_na_to_na = FALSE,
  strict = FALSE,
  unclass = FALSE,
  explicit_tagged_na = FALSE,
  ...
)

\method{to_factor}{data.frame}(
  x,
  levels = c("labels", "values", "prefixed"),
  ordered = FALSE,
  nolabel_to_na = FALSE,
  sort_levels = c("auto", "none", "labels", "values"),
  decreasing = FALSE,
  labelled_only = TRUE,
  drop_unused_labels = FALSE,
  strict = FALSE,
  unclass = FALSE,
  explicit_tagged_na = FALSE,
  ...
)

unlabelled(x, ...)
}
\arguments{
\item{x}{Object to coerce to a factor.}

\item{...}{Other arguments passed down to method.}

\item{levels}{What should be used for the factor levels: the labels, the values or labels prefixed with values?}

\item{ordered}{\code{TRUE} for ordinal factors, \code{FALSE} (default) for nominal factors.}

\item{nolabel_to_na}{Should values with no label be converted to \code{NA}?}

\item{sort_levels}{How the factor levels should be sorted? (see Details)}

\item{decreasing}{Should levels be sorted in decreasing order?}

\item{drop_unused_labels}{Should unused value labels be dropped?
(applied only if \code{strict = FALSE})}

\item{user_na_to_na}{Convert user defined missing values into \code{NA}?}

\item{strict}{Convert to factor only if all values have a defined label?}

\item{unclass}{If not converted to a factor (when \code{strict = TRUE}),
convert to a character or a numeric factor by applying \code{\link[base:class]{base::unclass()}}?}

\item{explicit_tagged_na}{Should tagged NA (cf. \code{\link[haven:tagged_na]{haven::tagged_na()}}) be
kept as explicit factor levels?}

\item{labelled_only}{for a data.frame, convert only labelled variables to factors?}
}
\description{
The base function \code{\link[base:factor]{base::as.factor()}} is not a generic, but this variant
is. By default, \code{to_factor()} is a wrapper for \code{\link[base:factor]{base::as.factor()}}.
Please note that \code{to_factor()} differs slightly from \code{\link[haven:as_factor]{haven::as_factor()}}
method provided by \pkg{haven} package.

\code{unlabelled(x)} is a shortcut for \code{to_factor(x, strict = TRUE, unclass = TRUE, labelled_only = TRUE)}.
}
\details{
If some values doesn't have a label, automatic labels will be created, except if
\code{nolabel_to_na} is \code{TRUE}.

If \code{sort_levels == 'values'}, the levels will be sorted according to the values of \code{x}.
If \code{sort_levels == 'labels'}, the levels will be sorted according to labels' names.
If \code{sort_levels == 'none'}, the levels will be in the order the value labels are defined
in \code{x}. If some labels are automatically created, they will be added at the end.
If \code{sort_levels == 'auto'}, \code{sort_levels == 'none'} will be used, except if some
values doesn't have a defined label. In such case, \code{sort_levels == 'values'} will
be applied.

When applied to a data.frame, only labelled vectors are converted by default to a
factor. Use \code{labelled_only = FALSE} to convert all variables to factors.

\code{unlabelled()} is a shortcut for quickly removing value labels of a vector
or of a data.frame. If all observed values have a value label, then the vector
will be converted into a factor. Otherwise, the vector will be unclassed.
If you want to remove value labels in all cases, use \code{\link[=remove_val_labels]{remove_val_labels()}}.
}
\examples{
v <- labelled(c(1,2,2,2,3,9,1,3,2,NA), c(yes = 1, no = 3, "don't know" = 9))
to_factor(v)
to_factor(v, nolabel_to_na = TRUE)
to_factor(v, 'p')
to_factor(v, sort_levels = 'v')
to_factor(v, sort_levels = 'n')
to_factor(v, sort_levels = 'l')

x <- labelled(c('H', 'M', 'H', 'L'), c(low = 'L', medium = 'M', high = 'H'))
to_factor(x, ordered = TRUE)

# Strict conversion
v <- labelled(c(1, 1, 2, 3), labels = c(No = 1, Yes = 2))
to_factor(v)
to_factor(v, strict = TRUE) # Not converted because 3 does not have a label
to_factor(v, strict = TRUE, unclass = TRUE)

df <- data.frame(
  a = labelled(c(1, 1, 2, 3), labels = c(No = 1, Yes = 2)),
  b = labelled(c(1, 1, 2, 3), labels = c(No = 1, Yes = 2, DK = 3)),
  c = labelled(c("a", "a", "b", "c"), labels = c(No = "a", Maybe = "b", Yes = "c")),
  d = 1:4,
  e = factor(c("item1", "item2", "item1", "item2")),
  f = c("itemA", "itemA", "itemB", "itemB"),
  stringsAsFactors = FALSE
)
if (require(dplyr)) {
  glimpse(df)
  glimpse(unlabelled(df))
}
}
