% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiny_label.R
\name{create_tiny_label}
\alias{create_tiny_label}
\title{Create tiny labels}
\usage{
create_tiny_label(
  data = NULL,
  qr = NULL,
  path = NULL,
  filename = NULL,
  field1.column = NULL,
  field2.column = NULL,
  field3.column = NULL,
  field4.column = NULL,
  field5.column = NULL,
  keep.files = FALSE,
  template = NULL
)
}
\arguments{
\item{data}{a data frame including information of a species}

\item{qr}{String. Free text or column of \code{data} that specifies the link for the QR code.
If the specified value of \code{qr} is not a column name of \code{data},
all the QRs will be equal, pointing to the same link.}

\item{path}{Character. Path to folder where the PDF file will be saved.}

\item{filename}{Character. Filename of the pdf. If NULL, default is "Tiny_label".}

\item{field1.column}{Character (optional). Name of the column in \code{data} storing the first free text to
appear at the top of the label.}

\item{field2.column}{Character (optional). Name of the column in \code{data} storing the second free text to
appear below field1.}

\item{field3.column}{Character (optional). Name of the column in \code{data} storing the third free text to
appear below field2.}

\item{field4.column}{Character (optional). Name of the column in \code{data} storing the fourth free text to
appear below field3.}

\item{field5.column}{Character (optional). Name of the column in \code{data} storing the fifth free text to
appear below field4.}

\item{keep.files}{Logical. Keep the RMarkdown template and associated files
in the output folder? Default is FALSE.}

\item{template}{Character (optional) RMarkdown template to use. If not provided,
using the default template included in \code{labeleR}.}
}
\value{
A PDF file named "Tiny_label.pdf" is saved on disk, in the folder defined
by \code{path}. If \code{keep.files = TRUE}, an RMarkdown file will also appear in the same folder.
}
\description{
Create tiny labels (16 labels per DIN-A4 page)
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
create_tiny_label(
  data = tiny.table,
  qr = "QR_code",
  path = "labeleR_output",
  field1.column = "field1",
  field2.column = "field2",
  field3.column = "field3",
  field4.column = "field4",
  field5.column = "field5"
)
\dontshow{\}) # examplesIf}
}
\author{
Ignacio Ramos-Gutierrez, Julia G. de Aledo, Francisco Rodriguez-Sanchez
}
