% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{keySave}
\alias{keySave}
\title{Save key as file after deducing type from suffix}
\usage{
keySave(obj, file, na_ = ".", varlab)
}
\arguments{
\item{obj}{a variable key object}

\item{file}{file name. must end in "csv", "xlsx" or "rds"}

\item{na_}{Value to insert to represent a missing score. Default
".".}

\item{varlab}{FALSE or TRUE. Default is FALSE, no new labels will
be created. If a key object has a varlab already, it is saved
with the key, always. This parameter controls whether a new
varlab template should be created when the object is saved.
If TRUE and obj has no varlab attribute, a new varlab template
is created by the \code{varlabTemplate} function. If TRUE and
a varlab attribute currently exists, but some variables are
missing labels, then \code{varlabTemplate} is called to fill
in new variable labels.}
}
\value{
NULL if no file is created. Otherwise, a key object with
    an attribute varlab is returned.
}
\description{
This is specialized to saving of key objects, it is not a
general purpose function for saving things.  It scans the
suffix of the file name and then does the right thing.
}
\details{
In updates 2017-09, a varlab element was introduced.  The varlab
attribute of the object is saved.  The files created incorporate
the variable labels object in different ways. 1) XLSX: variable
labels a worksheet named "varlab" 2) CSV: variable labels saved in
a separate file suffixed "-varlab.csv". 3) RDS: varlab is an
attribute of the key object.
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
