% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{is.data.frame.simple}
\alias{is.data.frame.simple}
\title{Check if a data frame is a simple collection of columns (no lists
or matrices within)}
\usage{
is.data.frame.simple(dframe)
}
\arguments{
\item{dframe}{A data frame}
}
\value{
Boolean, TRUE or FALSE. An attribute "not_a_simple_column"
    is created, indicating which of the elements in the dframe
    have dimensions
}
\description{
Checks for the existence of dimensions within the data
frame. Returns FALSE if any object within dframe has non-null dim
value.
}
\details{
See: http://stackoverflow.com/questions/38902880/data-frame-in-which-elements-are-not-single-columns
}
\examples{
N <- 100
mydf <- data.frame(x5 = rnorm(N),
                   x4 = rpois(N, lambda = 3),
                   x3 = ordered(sample(c("lo", "med", "hi"),
                   size = N, replace=TRUE)))
is.data.frame.simple(mydf)
mydf$amatr <- matrix(0, ncol = 2, nrow = NROW(mydf))
is.data.frame.simple(mydf)
mydf$amatr <- NULL
is.data.frame.simple(mydf)
mydf$adf <- mydf
is.data.frame.simple(mydf)
}
\author{
Paul Johnson <pauljohn@ku.edu>
}

