% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{heidel.welch}
\alias{heidel.welch}
\alias{heidel.welch.krige}
\alias{heidel.welch.summary.krige}
\alias{heidel.welch.default}
\title{Heidelberger and Welch Diagnostic for MCMC}
\usage{
heidel.welch(object, pvalue)

\method{heidel.welch}{krige}(object, pvalue = 0.05)

\method{heidel.welch}{summary.krige}(object, pvalue = 0.05)

\method{heidel.welch}{default}(object, pvalue = 0.05)
}
\arguments{
\item{object}{An matrix or \code{krige}/\code{summary.krige} object for which 
a Heidelberger and Welch diagnostic is desired}

\item{pvalue}{Alpha level for significance tests. Defaults to 0.05.}
}
\value{
A \code{matrix} in which the first row consists of the values of the 
  Cramer-von Mises test statistic for each parameter, and the second row consists 
  of the corresponding p-values. Each column of the matrix represents another 
  parameter of interest. A significant result serves as evidence of nonconvergence, 
  so non-significant results are desired.
}
\description{
Conducts a Heidelberger and Welch convergence diagnostic on MCMC iterations.
}
\details{
This is a generic function currently works with \code{matrix}, \code{krige}, 
  and \code{summary.krige} objects. It is a simplified version of the Heidelberger 
  and Welch test for use with this package.
  
   This is an adaptation of a function in Plummer et al.'s \code{coda} package. 
   Heidelberger and Welch's (1993) test for nonconvergence. This version of the 
   diagnostic only reports a Cramer-von Mises test and its corresponding p-value 
   to determine if the chain is weakly stationary with comparisons of early 
   portions of the chain to the end of the chain.
}
\examples{
\dontrun{
# Load Data
data(ContrivedData)

# Set seed
set.seed(1241060320)

M <- 100

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
  data = ContrivedData, n.iter = M, n.burnin = 20, range.tol = 0.05)

heidel.welch(contrived.run)
heidel.welch(summary(contrived.run))
heidel.welch(contrived.run$mcmc.mat)
}

}
\references{
Philip Heidelberger and Peter D. Welch. 1993. "Simulation Run Length Control 
in the Presence of an Initial Transient." \emph{Operations Research} 31:1109-1144.

Martyn Plummer, Nicky Best, Kate Cowles and Karen Vines. 2006. "CODA: Convergence 
Diagnosis and Output Analysis for MCMC." \emph{R News} 6:7-11.
}
\seealso{
\code{\link{heidel.welch.krige}}, \code{\link{heidel.welch.summary.krige}}, 
\code{\link{geweke}}
}
