context("data")

test_that("data", {
  expect_null(chk::check_data(
    section,
    list(
      Section = factor(1),
      Habitat = factor(c("Lentic", "Lentic", "Lotic"),
        levels = c("Lentic", "Lotic")
      ),
      Bounded = c(TRUE, TRUE, FALSE)
    ),
    key = "Section"
  ))

  expect_null(chk::check_data(
    station,
    list(
      Station = factor(1),
      Section = factor(1)
    ),
    key = "Station"
  ))

  expect_null(chk::chk_join(station, section, "Section"))

  expect_null(chk::check_data(
    deployment,
    list(
      Station = factor(1),
      Receiver = factor(1),
      DateTimeReceiverIn = Sys.time(),
      DateTimeReceiverOut = Sys.time()
    ),
    key = c("Station", "Receiver", "DateTimeReceiverIn")
  ))

  expect_null(chk::chk_join(deployment, station, "Station"))

  expect_null(chk::check_data(
    capture,
    list(
      Capture = factor(1),
      DateTimeCapture = Sys.time(),
      SectionCapture = factor(1),
      Species = factor(""),
      Length = c(200L, 1000L),
      Weight = c(0.5, 10, NA),
      Reward1 = c(0L, 10L, 100L),
      Reward2 = c(0L, 10L, 100L, NA),
      DateTimeTagExpire = Sys.time()
    ),
    key = c("Capture")
  ))

  expect_null(chk::chk_join(capture, section, c("SectionCapture" = "Section")))

  expect_null(chk::check_data(
    recapture,
    list(
      DateTimeRecapture = Sys.time(),
      Capture = factor(1),
      SectionRecapture = factor(c(1, NA)),
      TBarTag1 = TRUE,
      TBarTag2 = TRUE,
      TagsRemoved = TRUE,
      Released = TRUE,
      Public = TRUE
    ),
    key = c("DateTimeRecapture", "Capture")
  ))

  expect_null(chk::chk_join(recapture, capture, "Capture"))
  #  missing values
  #  expect_null(chk::chk_join(recapture, section@data,
  #                                   c("SectionRecapture" = "Section")))

  expect_null(chk::check_data(
    detection,
    list(
      DateTimeDetection = Sys.time(),
      Capture = factor(1),
      Receiver = factor(1),
      Detections = c(1L, 300L)
    ),
    key = c("DateTimeDetection", "Capture", "Receiver")
  ))

  expect_null(chk::chk_join(detection, capture, "Capture"))
})
