% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hent_data.R
\name{GetKlass}
\alias{GetKlass}
\title{Fetch classification data
Fetch Statistics Norway classification data using API}
\usage{
GetKlass(
  klass,
  date = NULL,
  correspond = NULL,
  output_level = NULL,
  language = "nb",
  output_style = "normal"
)
}
\arguments{
\item{klass}{Number/string of the classification ID/number. (use Klass_list() to find this)}

\item{date}{String for the required date of the classification. Format must be "yyyy-mm-dd". For an inverval, provide two dates as a vector. If blank, will default to today's date.}

\item{correspond}{Number/string of the target correspondence (if a correspondence table is requested).}

\item{output_level}{Number/string specifying the requested heirachy level (optional).}

\item{language}{Two letter string for the requested language output. Default is bokmål ("nb"). Nynorsk ("nn") and English ("en") also available for some classificatio.)}

\item{output_style}{String varibale for the output type. Default is "normal" and only option currently prorammed}
}
\value{
The function returns a data frame of the specified classification/correspondence table. Output variables include:
code, parentCode, level, and name for standard lists. For correspondence tables variables include:
sourceCode, sourceName, targetCode and targetName. For time correspondence tables variables include:
oldCode, oldName, newCode and newName.
}
\description{
Fetch classification data
Fetch Statistics Norway classification data using API
}
\examples{
# Get classification for occupation classifications
head(GetKlass(klass = "7"))
# Get classification for occupation classifications in English
head(GetKlass(klass = "7", language = "en"))
}
