% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys.R
\name{keysInput}
\alias{keysInput}
\title{Create a keys input control}
\usage{
keysInput(inputId, keys)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{keys}{A character vector of keys to bind. Examples include, \code{command},
\code{command+shift+a}, \verb{up down left right}, and more.}
}
\description{
Create a key input that can be used to observe keys pressed by
the user.
}
\examples{
\dontrun{
ui <- fluidPage(
  keysInput("keys", c(
    "1",
    "2",
    "3",
    "command+shift+k",
    "up up down down left right left right b a enter"
  )),
)

server <- function(input, output, session) {
  observeEvent(input$keys, {
    print(input$keys)
  })
}

shinyApp(ui, server)
}

}
