% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-env.R
\docType{data}
\name{backend_env}
\alias{backend_env}
\title{Store secrets in environment variables}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
backend_env
}
\description{
This is a simple keyring backend, that stores/uses secrets in
environment variables of the R session.
}
\details{
It does not support multiple keyrings. It also does not support listing
all keys, since there is no way to distinguish keys from regular
environment variables.

It does support service names and usernames: they will be separated
with a \code{:} character in the name of the environment variable. (Note that
such an environment variable typically cannot be set or queried from a
shell, but it can be set and queried from R or other programming
languages.)

See \link{backend} for the documentation of the class's methods.
}
\examples{
\dontrun{
env <- backend_env$new()
env$set("r-keyring-test", username = "donaldduck")
env$get("r-keyring-test", username = "donaldduck")
Sys.getenv("r-keyring-test:donaldduck")

# This is an error
env$list()

# Clean up
env$delete("r-keyring-test", username = "donaldduck")
}
}
\seealso{
Other keyring backends: \code{\link{backend_file}},
  \code{\link{backend_macos}},
  \code{\link{backend_secret_service}},
  \code{\link{backend_wincred}}
}
\keyword{datasets}
