% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{kpset}
\alias{kpset}
\title{Selecting the Most Central Group of Players in a Network}
\usage{
kpset(adj.matrix, size, type, M = Inf, T = ncol(adj.matrix), method,
  binary = FALSE, cmode, iteration = 1000)
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.}

\item{size}{Integer indicating the target size of players.}

\item{type}{\code{type="betweenness"} for \code{\link[sna]{betweenness}} centrality. \cr
\code{type="closeness"} for \code{\link[sna]{closeness}} centrality. \cr
\code{type="degree"} for \code{\link[sna]{degree}} centraslity. \cr
\code{type="diffusion"} for \code{\link{diffusion}} centrality. \cr
\code{type="evcent"} for \code{\link[sna]{evcent}} (eigenvector) centrality. \cr
\code{type="fragment"} for \code{\link{fragment}} centrality. \cr
\code{type="mreach.degree"} for \code{\link{mreach.degree}} centrality. \cr
\code{type="mreach.closeness"} for \code{\link{mreach.closeness}} centrality. \cr}

\item{M}{Positive number indicating the maximum geodistance between two nodes,
above witch the two nodes are considered disconnected. The default is
\code{Inf}. The option is applicable to mreach.degree, mreach.closeness,
and fragmentation centralities.}

\item{T}{Integer indicating the maximum number of iterations
of communication process. For diffusion centrality only.
In the first iteration, the adjacency matrix
is as the input. In the nth iteration, the adjacency matrix becomes
the input adjacency matrix to the power of n. By default, T is the network size.}

\item{method}{Indication of which grouping criterion should be used. \cr
\code{"min"} indicates the "minimum" criterion and is the default for
betweenness, closeness, fragmentation, and M-reach centralities. \cr
\code{"max"} indicates the "maximum" criterion and is the default for
degree and eigenvector centralities.\cr
\code{"add"} indicates the "addition" criterion.\cr
\code{"union"} indicates the "union" criterion and is the default for
diffusion centrality.\cr
See \code{\link{kpcent}} Details section for explanations on grouping method.}

\item{binary}{If \code{TRUE}, the adjacency matrix is binarized.
If \code{FALSE}, the edge values are considered. By default, \code{binary=FALSE}}

\item{cmode}{String indicating the type of centrality being evaluated.
The option is applicable to degree and M-reach centralities.
\code{"outdegree"}, \code{"indegree"}, and \code{"total"} refer to
indegree, outdegree, and (total) degree respectively. \code{"all"} reports
all the above measures. The default is to report the total degree.
The option also applies to closeness centrality, but with different options.
The default is to use the Gil-Schmidt power index as the closeness measure.
See \code{\link[sna]{closeness}} for complete options.}

\item{iteration}{The upper boound of the number of search amount. See
Details section for the definition.}
}
\value{
\code{kpset} returns the column indices of the players who form
the most central set and its centrality score.
}
\description{
\code{kpset} implements a greedy search algorithm to find the most
central players given the sepcified centraliy measure and the target group size.
}
\details{
The most central individuals together do not necessarily form the most
central set in a netowrk as they may share overlapped connections. Hence,
a greedy search algorithm is implemented here to identify the key set of
players. The basic logic is as the following:
\enumerate{
\item Randomly select a set of nodes \emph{C}. The remaining set of nodes is denoted as \emph{R}.
\item Update the selected set \emph{C}.
  \enumerate{
  \item Replace node \emph{i} in \emph{C} with node \emph{j} in \emph{R}.
        Replace \emph{i} by \emph{j} if the \emph{j}th replacement improves
        the centrality of \emph{C} the most. (loop 1)
  \item Repeat loop 1 for each node in \emph{C} (loop 2)
  \item Stop if (a) the change in \emph{C}'s centrality score is smaller than
        a specified threshold or (b) the process reaches the specified number
        of iterations (i.e., the number of loop 2).
  }
\item Return the final candidate set and the centrality score.
}

See empirical examples in An and Liu (2015).
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# Find the most central player set sized 2 in terms of the degree centrality
kpset(W,size=2,type="degree")
}
\author{
Weihua An \email{weihuaan@indiana.edu}; Yu-Hsin Liu \email{yuhsliu@indiana.edu}
}
\references{
An, Weihua. (2015). "Multilevel Meta Network Analysis with Application to Studying Network Dynamics of Network Interventions." \emph{Social Networks} 43: 48-56.\cr

An, Weihua and Yu-Hsin Liu (2015). "keyplayer: An R Package for Locating Key Players in Social Networks."
\emph{Working Paper}, Indiana Univeristy.\cr

Borgatti, Stephen P. (2006). "Identifying Sets of Key Players in a Network." \emph{Computational, Mathematical and Organizational Theory}, 12(1):21-34.\cr

Butts, Carter T. (2014). sna: Tools for Social Network Analysis. R package
version 2.3-2. \url{http://CRAN.R-project.org/package=sna}\cr
}

