% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id.R
\name{keyholder-id}
\alias{keyholder-id}
\alias{use_id}
\alias{compute_id_name}
\alias{add_id}
\alias{key_by_id}
\title{Add id column and key}
\usage{
use_id(.tbl)

compute_id_name(x)

add_id(.tbl)

key_by_id(.tbl, .add = FALSE, .exclude = FALSE)
}
\arguments{
\item{.tbl}{Reference data frame.}

\item{x}{Character vector of names.}

\item{.add, .exclude}{Parameters for \code{\link[=key_by]{key_by()}}.}
}
\description{
Functions for creating id column and key.
}
\details{
\code{use_id()} \link[=keys-set]{assigns} as keys a tibble with column '.id'
and row numbers of \code{.tbl} as values.

\code{compute_id_name()} computes the name which is different from every
element in \code{x} by the following algorithm: if '.id' is not present in \code{x} it
is returned; if taken - '.id1' is checked; if taken - '.id11' is checked and
so on.

\code{add_id()} creates a column with unique name (computed with
\code{compute_id_name()}) and row numbers as values (grouping is ignored). After
that puts it as first column.

\code{key_by_id()} is similar to \code{add_id()}: it creates a column with unique name
and row numbers as values (grouping is ignored) and calls \code{\link[=key_by]{key_by()}} function
to use this column as key. If \code{.add} is \code{FALSE} unique name is computed based
on \code{.tbl} column names; if \code{TRUE} then based on \code{.tbl} and its keys column
names.
}
\examples{
mtcars \%>\% use_id()

mtcars \%>\% add_id()

mtcars \%>\% key_by_id(.exclude = TRUE)

}
