% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{visualize_keywords}
\alias{visualize_keywords}
\title{Visualize keywords}
\usage{
visualize_keywords(docs, keywords, prune = TRUE, label_size = 3.2)
}
\arguments{
\item{docs}{a keyATM_docs object, generated by \code{keyATM_read()} function}

\item{keywords}{a list of keywords}

\item{prune}{logical. If \code{TRUE}, prune keywords that do not appear in `docs`. Default is \code{TRUE}.}

\item{label_size}{the size of keyword labels in the output plot. Default is 3.2.}
}
\value{
A list containing \describe{
   \item{figure}{a ggplot2 object}
   \item{values}{a tibble object that stores values}
   \item{keywords}{a list of keywords that appear in documents}
}
}
\description{
Visualize the proportion of keywords in the documents.
}
\examples{
\dontrun{
 # Prepare a keyATM_docs object
 keyATM_docs <- keyATM_read(input)
  
 # Keywords are in a list  
 keywords <- list(
                   c("education", "child", "student"),  # Education
                   c("public", "health", "program"),  # Health
                 )

 # Visualize keywords
 keyATM_viz <- visualize_keywords(keyATM_docs, keywords)

 # View a figure
 keyATM_viz
   # Or: `keyATM_viz$figure`

 # Save a figure 
 save_fig(keyATM_viz, filename)

}

}
