% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{keras-package}
\alias{keras-package}
\title{R interface to Keras}
\description{
Keras is a high-level neural networks API, developed with a focus on enabling
fast experimentation. Keras has the following key features:
}
\details{
\itemize{
\item Allows the same code to run on CPU or on GPU, seamlessly.
\item User-friendly API which makes it easy to quickly prototype deep learning models.
\item Built-in support for convolutional networks (for computer vision), recurrent
networks (for sequence processing), and any combination of both.
\item Supports arbitrary network architectures: multi-input or multi-output models,
layer sharing, model sharing, etc. This means that Keras is appropriate for
building essentially any deep learning model, from a memory network to a neural
Turing machine.
\item Is capable of running on top of multiple back-ends including
\href{https://github.com/tensorflow/tensorflow}{TensorFlow},
\href{https://github.com/Microsoft/cntk}{CNTK},
or \href{https://github.com/Theano/Theano}{Theano}.
}

See the package website at \url{https://tensorflow.rstudio.com} for complete documentation.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://tensorflow.rstudio.com/}
  \item \url{https://github.com/rstudio/keras3/tree/r2}
  \item Report bugs at \url{https://github.com/rstudio/keras3/issues}
}

}
\author{
\strong{Maintainer}: Tomasz Kalinowski \email{tomasz@posit.co} [contributor, copyright holder]

Authors:
\itemize{
  \item JJ Allaire [copyright holder]
  \item François Chollet [copyright holder]
}

Other contributors:
\itemize{
  \item Daniel Falbel \email{daniel@rstudio.com} [contributor, copyright holder]
  \item RStudio [contributor, copyright holder, funder]
  \item Google [contributor, copyright holder, funder]
  \item Yuan Tang \email{terrytangyuan@gmail.com} (\href{https://orcid.org/0000-0001-5243-233X}{ORCID}) [contributor, copyright holder]
  \item Wouter Van Der Bijl [contributor, copyright holder]
  \item Martin Studer [contributor, copyright holder]
  \item Sigrid Keydana [contributor]
}

}
