% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{fit_generator}
\alias{fit_generator}
\title{Fits the model on data yielded batch-by-batch by a generator.}
\usage{
fit_generator(object, generator, steps_per_epoch, epochs = 1, verbose = 1,
  callbacks = NULL, view_metrics = getOption("keras.view_metrics", default =
  "auto"), validation_data = NULL, validation_steps = NULL,
  class_weight = NULL, max_queue_size = 10, initial_epoch = 0)
}
\arguments{
\item{object}{Keras model object}

\item{generator}{A generator (e.g. like the one provided by
\code{\link[=flow_images_from_directory]{flow_images_from_directory()}} or a custom R \href{https://rstudio.github.io/reticulate/articles/introduction.html#generators}{generator function}).

The output of the generator must be a list of one of these forms:\preformatted{ - (inputs, targets)
 - (inputs, targets, sample_weights)
}

Note that the generator should call the \code{\link[=to_numpy_array]{to_numpy_array()}} function on its
results prior to returning them (this ensures that arrays are provided in
'C' order and using the default floating point type for the backend.)

All arrays should contain the same number of samples. The generator is expected
to loop over its data indefinitely. An epoch finishes when \code{steps_per_epoch}
batches have been seen by the model.}

\item{steps_per_epoch}{Total number of steps (batches of samples) to yield
from \code{generator} before declaring one epoch finished and starting the next
epoch. It should typically be equal to the number of unique samples if your
dataset divided by the batch size.}

\item{epochs}{integer, total number of iterations on the data.}

\item{verbose}{Verbosity mode (0 = silent, 1 = verbose, 2 = one log line per
epoch).}

\item{callbacks}{list of callbacks to be called during training.}

\item{view_metrics}{View realtime plot of training metrics (by epoch). The
default (\code{"auto"}) will display the plot when running within RStudio,
\code{metrics} were specified during model \code{\link[=compile]{compile()}}, \code{epochs > 1} and
\code{verbose > 0}. Use the global \code{keras.view_metrics} option to establish a
different default.}

\item{validation_data}{this can be either:
\itemize{
\item a generator for the validation data
\item a list (inputs, targets)
\item a list (inputs, targets, sample_weights).
}}

\item{validation_steps}{Only relevant if \code{validation_data} is a generator.
Total number of steps (batches of samples) to yield from \code{generator} before
stopping.}

\item{class_weight}{dictionary mapping class indices to a weight for the
class.}

\item{max_queue_size}{maximum size for the generator queue}

\item{initial_epoch}{epoch at which to start training (useful for resuming a
previous training run)}
}
\value{
Training history object (invisibly)
}
\description{
The generator is run in parallel to the model, for efficiency. For instance,
this allows you to do real-time data augmentation on images on CPU in
parallel to training your model on GPU.
}
\seealso{
Other model functions: \code{\link{compile}},
  \code{\link{evaluate_generator}}, \code{\link{evaluate}},
  \code{\link{fit}}, \code{\link{get_config}},
  \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_generator}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}},
  \code{\link{train_on_batch}}
}
