% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rep_frac_pct.R
\name{rep_frac_pct}
\alias{rep_frac_pct}
\title{rep_frac_pct}
\usage{
rep_frac_pct(
  count,
  count_reference,
  digits = 2,
  na.rm = TRUE,
  brackets = c("round", "square"),
  suffix = TRUE
)
}
\arguments{
\item{count}{A numeric. The numerator.}

\item{count_reference}{A numeric. The denominator.}

\item{digits}{An integer indicating the number of decimal places.}

\item{na.rm}{A logical indicating if missings should be removed from \code{x}
before computing the distributional parameters (default: \code{TRUE}).}

\item{brackets}{A character. Either \code{"round"} (default) or \code{"square"} to
indicate the type of brackets to surround the relative count.}

\item{suffix}{A character which is placed between the lower and the upper
confidence bound in the formatted output.}
}
\value{
A character with the formatted output.
}
\description{
Reporting helper function: computes and formats the relative
percentage of a fraction.
}
\examples{
rep_frac_pct(count = 40, count_reference = 200)
rep_frac_pct(count = 40, count_reference = 200, brackets = "square")
rep_frac_pct(40, 200, brackets = "square", suffix = FALSE)

}
\seealso{
\link[stats:median]{stats::median}, \link[stats:quantile]{stats::quantile}, \code{\link[Hmisc:wtd.stats]{Hmisc::wtd.quantile()}}
}
