% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builtin_starts_estimation.R
\name{mlgamma}
\alias{mlgamma}
\title{Estimates the parameter of the Gamma distribution using maximum likelihood}
\usage{
mlgamma(x, rel.tol = .Machine$double.eps^0.25, iterlim = 100)
}
\arguments{
\item{x}{The data from which the estimate is to be computed.}

\item{rel.tol}{Relative accuracy requested.}

\item{iterlim}{A positive integer specifying the maximum number of
iterations to be performed before the program is terminated.}
}
\value{
A named numeric vector with maximum likelihood estimates for
\code{shape} and \code{rate}.
}
\description{
Uses Newton-Raphson to estimate the parameters of the Gamma distribution.
}
\references{
Choi, S. C, and R. Wette. "Maximum likelihood estimation of the parameters of the gamma distribution and their bias." Technometrics 11.4 (1969): 683-690.
}
\keyword{internal}
