% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_row_counts.R
\name{summarize_row_counts}
\alias{summarize_row_counts}
\title{Layout Creating Function Adding Row Counts}
\usage{
summarize_row_counts(lyt, label_fstr = "\%s", alt_counts = TRUE)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{label_fstr}{(\code{string})\cr a \code{sprintf} style format string.
It can contain up to one \verb{\%s} which takes the current split value and
generates the row label.}

\item{alt_counts}{(\code{flag})\cr whether row counts should be taken from
\code{alt_counts_df} (\code{TRUE}) or from \code{df} (\code{FALSE}).}
}
\value{
A modified layout where the latest row split now has a row group
summaries (as created by \link[rtables:summarize_row_groups]{rtables::summarize_row_groups} for the counts.
for the counts.
}
\description{
This is a simple wrapper of \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}} and the main
additional value is that we can choose whether we want to use the alternative
(usually ADSL) data set for the counts (default) or use the original data set.
}
\examples{
basic_table() |>
  split_cols_by("ARM") |>
  add_colcounts() |>
  split_rows_by("RACE", split_fun = drop_split_levels) |>
  summarize_row_counts(label_fstr = "RACE value - \%s") |>
  analyze("AGE", afun = list_wrap_x(summary), format = "xx.xx") |>
  build_table(DM, alt_counts_df = rbind(DM, DM))

}
