% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportions.R
\name{prop_post_fun}
\alias{prop_post_fun}
\alias{prop_split_fun}
\title{Split Function for Proportion Analysis Columns (TEFCGIS08 e.g.)}
\usage{
prop_post_fun(ret, spl, fulldf, .spl_context)

prop_split_fun(df, spl, vals = NULL, labels = NULL, trim = FALSE, .spl_context)
}
\arguments{
\item{ret}{(\code{list})\cr return value from the previous split function.}

\item{spl}{(\code{list})\cr split information.}

\item{fulldf}{(\code{data.frame})\cr full data frame.}

\item{.spl_context}{(\code{environment})\cr split context environment.}

\item{df}{A data frame that contains all analysis variables.}

\item{vals}{A character vector that contains values to use for the split.}

\item{labels}{A character vector that contains labels for the statistics (without indent).}

\item{trim}{A single logical that indicates whether to trim the values.}
}
\value{
a split function for use in \link[rtables:split_rows_by]{rtables::split_rows_by}.
}
\description{
Here we just split into 3 columns \code{n}, \verb{\%} and \verb{Cum \%}.
}
\note{
This split function is used in the proportion table TEFCGIS08 and similar ones.
}
\seealso{
\code{\link[rtables:make_split_fun]{rtables::make_split_fun()}} describing the requirements for this kind of
post-processing function.
}
