% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_proportion_diff.R
\name{prop_diff}
\alias{prop_diff}
\alias{a_proportion_diff_j}
\alias{s_proportion_diff_j}
\title{Proportion difference estimation}
\usage{
a_proportion_diff_j(
  df,
  .var,
  ref_path,
  .spl_context,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_proportion_diff_j(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  variables = list(strata = NULL),
  conf_level = 0.95,
  method = c("waldcc", "wald", "cmh", "ha", "newcombe", "newcombecc", "strat_newcombe",
    "strat_newcombecc"),
  weights_method = "cmh"
)
}
\arguments{
\item{df}{(\code{data.frame})\cr input data frame.}

\item{.var}{(\code{string})\cr name of the response variable.}

\item{ref_path}{(\code{character})\cr path to the reference group.}

\item{.spl_context}{(\code{environment})\cr split context environment.}

\item{...}{Additional arguments passed to the statistics function.}

\item{.stats}{(\code{character})\cr statistics to calculate.}

\item{.formats}{(\code{list})\cr formats for the statistics.}

\item{.labels}{(\code{list})\cr labels for the statistics.}

\item{.indent_mods}{(\code{list})\cr indentation modifications for the statistics.}

\item{.ref_group}{(\code{data.frame})\cr reference group data frame.}

\item{.in_ref_col}{(\code{logical})\cr whether the current column is the reference column.}

\item{variables}{(\code{list})\cr list with strata variable names.}

\item{conf_level}{(\code{numeric})\cr confidence level for the confidence interval.}

\item{method}{(\code{string})\cr method to use for confidence interval calculation.}

\item{weights_method}{(\code{string})\cr method to use for weights calculation in stratified analysis.}
}
\value{
\itemize{
\item \code{a_proportion_diff_j()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{s_proportion_diff_j()} returns a named list of elements \code{diff},
\code{diff_ci}, \code{diff_est_ci} and \code{diff_ci_3d}.
}
}
\description{
The analysis function \code{\link[=a_proportion_diff_j]{a_proportion_diff_j()}} can be used to create a layout element to estimate
the difference in proportion of responders within a studied population. The primary analysis variable,
\code{vars}, is a logical variable indicating whether a response has occurred for each record. See the \code{method}
parameter for options of methods to use when constructing the confidence interval of the proportion difference.
A stratification variable can be supplied via the \code{strata} element of the \code{variables} argument.
}
\section{Functions}{
\itemize{
\item \code{a_proportion_diff_j()}: Formatted analysis function which is used as \code{afun} in \code{estimate_proportion_diff()}.

\item \code{s_proportion_diff_j()}: Statistics function estimating the difference
in terms of responder proportion.

}}
\note{
The \code{\link[=a_proportion_diff_j]{a_proportion_diff_j()}} function has the \verb{_j} suffix to distinguish it
from \code{\link[tern:prop_diff]{tern::a_proportion_diff()}}. The functions here are a copy from the \code{tern} package
with additional features:
\itemize{
\item Additional statistic \code{diff_est_ci} is returned.
\item \code{ref_path} needs to be provided as extra argument to specify the control group column.
}

When performing an unstratified analysis, methods \code{'cmh'}, \code{'strat_newcombe'},
and \code{'strat_newcombecc'} are not permitted.
}
\examples{
nex <- 100
dta <- data.frame(
  "rsp" = sample(c(TRUE, FALSE), nex, TRUE),
  "grp" = sample(c("A", "B"), nex, TRUE),
  "f1" = sample(c("a1", "a2"), nex, TRUE),
  "f2" = sample(c("x", "y", "z"), nex, TRUE),
  stringsAsFactors = TRUE
)

l <- basic_table() |>
  split_cols_by(var = "grp") |>
  analyze(
    vars = "rsp",
    afun = a_proportion_diff_j,
    show_labels = "hidden",
    na_str = tern::default_na_str(),
    extra_args = list(
      conf_level = 0.9,
      method = "ha",
      ref_path = c("grp", "B")
    )
  )

build_table(l, df = dta)

s_proportion_diff_j(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  conf_level = 0.90,
  method = "ha"
)

s_proportion_diff_j(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  variables = list(strata = c("f1", "f2")),
  conf_level = 0.90,
  method = "cmh"
)

}
