% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_freq_funs.R
\name{h_a_freq_dataprep}
\alias{h_a_freq_dataprep}
\title{A Frequency Data Preparation Function}
\usage{
h_a_freq_dataprep(
  df,
  labelstr = NULL,
  .var = NA,
  val = NULL,
  drop_levels = FALSE,
  excl_levels = NULL,
  new_levels = NULL,
  new_levels_after = FALSE,
  addstr2levs = NULL,
  .df_row,
  .spl_context,
  .N_col,
  id = "USUBJID",
  denom = c("N_col", "n_df", "n_altdf", "N_colgroup", "n_rowdf", "n_parentdf"),
  variables,
  label = NULL,
  label_fstr = NULL,
  label_map = NULL,
  .alt_df_full = NULL,
  denom_by = NULL,
  .stats
)
}
\arguments{
\item{df}{Data frame to prepare.}

\item{labelstr}{Label string.}

\item{.var}{Variable name.}

\item{val}{Values for analysis.}

\item{drop_levels}{Boolean, indicating if levels should be dropped.}

\item{excl_levels}{Levels to exclude.}

\item{new_levels}{New levels to add.}

\item{new_levels_after}{Boolean for adding new levels after existing ones.}

\item{addstr2levs}{String to add to new levels.}

\item{.df_row}{Current data frame row.}

\item{.spl_context}{Current split context.}

\item{.N_col}{Number of columns.}

\item{id}{Identifier variable.}

\item{denom}{Denominator types.}

\item{variables}{Variables to include in the analysis.}

\item{label}{Label string.}

\item{label_fstr}{Formatted label string.}

\item{label_map}{Mapping for labels.}

\item{.alt_df_full}{Alternative full data frame.}

\item{denom_by}{Denominator grouping variable.}

\item{.stats}{Statistics to compute.}
}
\value{
List containing prepared data frames and values.
}
\description{
Prepares frequency data for analysis.
}
