% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gscale.R
\name{center}
\alias{center}
\title{Mean-center vectors, data frames, and survey designs}
\usage{
center(data = NULL, vars = NULL, binary.inputs = "center",
  binary.factors = TRUE, weights = NULL)
}
\arguments{
\item{data}{A data frame or survey design. Only needed if you would like to
rescale multiple variables at once. If \code{x = NULL}, all columns will
be rescaled. Otherwise, \code{x} should be a vector of variable names. If
\code{x} is a numeric vector, this argument is ignored.}

\item{vars}{If \code{data} is a data.frame or similar, you can scale only
select columns by providing a vector column names to this argument.}

\item{binary.inputs}{Options for binary variables. Default is \code{center};
\code{0/1} keeps original scale; \code{-0.5/0.5} rescales 0 as -0.5 and 1
as 0.5; \code{center} subtracts the mean; and \code{full} subtracts the
mean and divides by 2 sd.}

\item{binary.factors}{Coerce two-level factors to numeric and apply scaling
functions to them? Default is TRUE.}

\item{weights}{A vector of weights equal in length to \code{x}. If iterating
over a data frame, the weights will need to be equal in length to all the
columns to avoid errors. You may need to remove missing values before using
the weights.}
}
\value{
A transformed version of the \code{data} argument.
}
\description{
This function is a wrapper around \code{\link[=gscale]{gscale()}} that is configured
to mean-center variables without affecting the scaling of those variables.
}
\details{
Some more information can be found in the documentation for
\code{\link[=gscale]{gscale()}}
}
\examples{

# Standardize just the "qsec" variable in mtcars
standardize(mtcars, vars = "qsec")

}
\seealso{
Other standardization, scaling, and centering tools: \code{\link{center_mod}},
  \code{\link{gscale}}, \code{\link{scale_mod}},
  \code{\link{standardize}}
}
\concept{standardization, scaling, and centering tools}
