## ----echo=FALSE----------------------------------------------------------
knitr::opts_chunk$set(message=F, warning=F)
library(jtools)

## ------------------------------------------------------------------------
# Fit model
fit <- lm(Income ~ Frost + Illiteracy + Murder, data = as.data.frame(state.x77))
j_summ(fit)

## ------------------------------------------------------------------------
j_summ(fit, model.info = FALSE, model.fit = FALSE)

## ------------------------------------------------------------------------
j_summ(fit, model.check = TRUE)

## ------------------------------------------------------------------------
j_summ(fit, robust = TRUE, robust.type = "HC3")

## ------------------------------------------------------------------------
j_summ(fit, digits=5)

## ------------------------------------------------------------------------
j_summ(fit, digits=1)

## ------------------------------------------------------------------------
j <- j_summ(fit, digits = 3)

j$coeftable

## ------------------------------------------------------------------------
j_summ(fit, vifs = TRUE)

## ------------------------------------------------------------------------
j_summ(fit, standardize = TRUE)

## ------------------------------------------------------------------------
j_summ(fit, standardize = TRUE, n.sd = 2)

## ------------------------------------------------------------------------
j_summ(fit, center = TRUE)

