% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsonstat.R
\name{as.jsonstat.jsonstat.dataset}
\alias{as.jsonstat.jsonstat.dataset}
\title{Convert JSON-stat dataset into JSON}
\usage{
\method{as.jsonstat}{jsonstat.dataset}(x)
}
\arguments{
\item{x}{JSON-stat dataset}
}
\value{
JSON output
}
\description{
Convert JSON-stat dataset into JSON
}
\examples{
library(jsonstat)
library(dplyr)

.plan <- compress_plan("place.of.birth", "geo", "Place of Birth") \%>\%
  dimension("age.group", "classification", "Age Group") \%>\%
  dimension("gender", "classification", "Gender") \%>\%
  dimension("year", "time", "Year") \%>\%
  dimension("province.of.residence", "geo", "Province of Residence") \%>\%
  dimension("concept", "metric", "Concept") \%>\%
  dimension("value", "value", "value")

.dataset <- as.dataset(galicia, .plan,
              label = paste("Population by province of residence,",
                            "place of birth, age, gender and year",
                            "in Galicia"),
              href = "https://github.com/zedoul/jsonstat")

.jsonstat <- as.jsonstat(.dataset)
}
