% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpairs.R
\name{ggpairsModule}
\alias{ggpairsModule}
\title{ggpairsModule: shiny module server for basic/scatter plot.}
\usage{
ggpairsModule(input, output, session, data, data_label,
  data_varStruct = NULL)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{data}

\item{data_label}{data label}

\item{data_varStruct}{List of variable structure, Default: NULL}
}
\value{
Shiny module server for basic/scatter plot.
}
\description{
Shiny module server for basic/scatter plot.
}
\details{
Shiny module server for basic/scatter plot.
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable);library(ggplot2)
library(GGally)

ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     ggpairsModuleUI1("ggpairs")
   ),
   mainPanel(
     plotOutput("ggpairs_plot"),
     ggpairsModuleUI2("ggpairs")
   )
 )
)

server <- function(input, output, session) {

  data <- mtcars
  data.label <- jstable::mk.lev(mtcars)

  out_ggpairs <- callModule(ggpairsModule, "ggpairs", data = data, data_label = data.label,
                            data_varStruct = NULL)

  output$kaplan_plot <- renderPlot({
    print(out_ggpairs())
  })
}
}
