% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spdf_jpn.R
\name{jpn_pref}
\alias{jpn_pref}
\title{Simple features for prefecture area polygon}
\usage{
jpn_pref(pref_code, admin_name, district = TRUE, download = FALSE,
  drop_sinkyokyoku = TRUE)
}
\arguments{
\item{pref_code}{jis code from 1 to 47 (integer)}

\item{admin_name}{prefecture names (string)}

\item{district}{logical (default TRUE)}

\item{download}{logical (default FALSE).}

\item{drop_sinkyokyoku}{if TRUE, drop sichyo_sinkyokyoku variable (default TRUE)}
}
\description{
Prefecture polygon data.
}
\details{
Collect unit of prefecture simple feature data.frame objects.. If downalod argument is TRUE,
download administrative area data from the National Land Numeral Information Download Service (for law data).
}
\examples{
\dontrun{
jpn_pref(pref_code = 33, district = FALSE)
jpn_pref(pref_code = 14, district = TRUE)
}

}
