% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_print_journal.R
\name{format_journal_clu}
\alias{format_journal_clu}
\title{Format central, lower, upper value triplets for journal presentation}
\usage{
format_journal_clu(central, lower, upper, d_type, style_name = "nature")
}
\arguments{
\item{central}{[num] central, point_estimate value vector}

\item{lower}{[num] lower bound vector}

\item{upper}{[num] upper bound vector}

\item{d_type}{[chr c(prop, pp, count)] data type - proportion, percentage}

\item{style_name}{[chr: default 'nature'] style name - controls rounding and
formatting.}
}
\value{
[chr] formatted string vector
}
\description{
Defaults are generic.  This function allows special formtting marks to be
applied by journal. Use `format_lancet_clu()` for Lancet-specific formatting.
Use `format_nature_clu()` for Nature-specific formatting.
}
\details{
Takes three vectors as main arguments for data.table-friendly vectorization.

`central` could be mean, median, point_estimate

Transform c(central = 0.994, lower = 0.984, upper = 0.998) to "99.4%
(98.4–99.8)"

Accounts for negative values, and UIs that cross zero.  Checks if
central, lower, upper values are in the correct order.
}
\examples{
format_journal_clu(
 central = c(0.994, -0.994)
 , lower = c(0.984, -0.998)
 , upper = c(0.998, -0.984)
 , d_type = "prop"
)
}
\seealso{
Other styled_formats: 
\code{\link{format_journal_df}()},
\code{\link{format_lancet_clu}()},
\code{\link{format_lancet_df}()},
\code{\link{format_means_df}()},
\code{\link{format_nature_clu}()},
\code{\link{format_nature_df}()},
\code{\link{fround_clu_triplet}()},
\code{\link{new_style}()}
}
\concept{styled_formats}
