% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{constructFormula}
\alias{constructFormula}
\title{Construct a formula string}
\usage{
constructFormula(dep = NULL, terms)
}
\arguments{
\item{dep}{the name of the dependent variable}

\item{terms}{list of character vectors making up the terms}
}
\value{
a string representation of the formula
}
\description{
Construct a formula string
}
\examples{

constructFormula(terms=list('a', 'b', c('a', 'b')))
# a+b+a:b

constructFormula('f', list('a', 'b', c('a', 'b')))
# "f~a+b+a:b"

constructFormula('with spaces', list('a', 'b', c('a', 'b')))
'`with spaces`~a+b+a:b'

}
