% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logregord.h.R
\name{logRegOrd}
\alias{logRegOrd}
\title{Ordinal Logistic Regression}
\usage{
logRegOrd(
  data,
  dep,
  covs = NULL,
  factors = NULL,
  blocks = list(list()),
  refLevels = NULL,
  modelTest = FALSE,
  dev = TRUE,
  aic = TRUE,
  bic = FALSE,
  pseudoR2 = list("r2mf"),
  omni = FALSE,
  thres = FALSE,
  ci = FALSE,
  ciWidth = 95,
  OR = FALSE,
  ciOR = FALSE,
  ciWidthOR = 95
)
}
\arguments{
\item{data}{the data as a data frame}

\item{dep}{a string naming the dependent variable from \code{data},
variable must be a factor}

\item{covs}{a vector of strings naming the covariates from \code{data}}

\item{factors}{a vector of strings naming the fixed factors from
\code{data}}

\item{blocks}{a list containing vectors of strings that name the predictors
that are added to the model. The elements are added to the model according
to their order in the list}

\item{refLevels}{a list of lists specifying reference levels of the
dependent variable and all the factors}

\item{modelTest}{\code{TRUE} or \code{FALSE} (default), provide the model
comparison between the models and the NULL model}

\item{dev}{\code{TRUE} (default) or \code{FALSE}, provide the deviance (or
-2LogLikelihood) for the models}

\item{aic}{\code{TRUE} (default) or \code{FALSE}, provide Aikaike's
Information Criterion (AIC) for the models}

\item{bic}{\code{TRUE} or \code{FALSE} (default), provide Bayesian
Information Criterion (BIC) for the models}

\item{pseudoR2}{one or more of \code{'r2mf'}, \code{'r2cs'}, or
\code{'r2n'}; use McFadden's, Cox & Snell, and Nagelkerke pseudo-R²,
respectively}

\item{omni}{\code{TRUE} or \code{FALSE} (default), provide the omnibus
likelihood ratio tests for the predictors}

\item{thres}{\code{TRUE} or \code{FALSE} (default), provide the thresholds
that are used as cut-off scores for the levels of the dependent variable}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide a confidence
interval for the model coefficient estimates}

\item{ciWidth}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width}

\item{OR}{\code{TRUE} or \code{FALSE} (default), provide the exponential of
the log-odds ratio estimate, or the odds ratio estimate}

\item{ciOR}{\code{TRUE} or \code{FALSE} (default), provide a confidence
interval for the model coefficient odds ratio estimates}

\item{ciWidthOR}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$modelFit} \tab \tab \tab \tab \tab a table \cr
  \code{results$modelComp} \tab \tab \tab \tab \tab a table \cr
  \code{results$models} \tab \tab \tab \tab \tab an array of model specific results \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$modelFit$asDF}

\code{as.data.frame(results$modelFit)}
}
\description{
Ordinal Logistic Regression
}
\examples{
set.seed(1337)

y <- factor(sample(1:3, 100, replace = TRUE))
x1 <- rnorm(100)
x2 <- rnorm(100)

df <- data.frame(y=y, x1=x1, x2=x2)

logRegOrd(data = df, dep = y,
          covs = vars(x1, x2),
          blocks = list(list("x1", "x2")))

#
#  ORDINAL LOGISTIC REGRESSION
#
#  Model Fit Measures
#  ---------------------------------------
#    Model    Deviance    AIC    R²-McF
#  ---------------------------------------
#        1         218    226    5.68e-4
#  ---------------------------------------
#
#
#  MODEL SPECIFIC RESULTS
#
#  MODEL 1
#
#  Model Coefficients
#  ----------------------------------------------------
#    Predictor    Estimate    SE       Z        p
#  ----------------------------------------------------
#    x1             0.0579    0.193    0.300    0.764
#    x2             0.0330    0.172    0.192    0.848
#  ----------------------------------------------------
#
#

}
