% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetJRowNames}
\alias{GetJRowNames}
\title{GetJRowNames}
\usage{
GetJRowNames(fname)
}
\arguments{
\item{fname}{String with the file name that contains the binary data.}
}
\value{
A R StringVector with the row names, or the empty vector if the binary file has no row names as metadata.
}
\description{
Returns a R StringVector with the row names of a matrix stored in the binary format of package jmatrix, if it has them stored.
}
\examples{
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
rn<-GetJRowNames("Rfullfloat.bin")
rn
file.remove("Rfullfloat.bin")
}
