% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\title{Audit Sampling: Reporting}
\usage{
report(object,
       file = "report.html")
}
\arguments{
\item{object}{an object of class \code{jfaEvaluation} as returned by the
\code{evaluation()} function.}

\item{file}{a character specifying the name and format of the report (e.g.
\code{report.html}).}
}
\value{
A \code{html} or \code{pdf} file containing the report.
}
\description{
\code{report()} takes an object of class \code{jfaEvaluation} as
returned by the \code{evaluation()} function automatically generates a
\code{html} or \code{pdf} report containing the most relevant statistical
results and their interpretation.
}
\examples{
result <- evaluation(x = 0, n = 100)
\dontrun{
report(result)
}
}
\seealso{
\code{\link{auditPrior}}
         \code{\link{planning}}
         \code{\link{selection}}
         \code{\link{evaluation}}
}
\author{
Koen Derks, \email{k.derks@nyenrode.nl}
}
\keyword{audit}
\keyword{evaluation}
\keyword{report}
