% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planning.R
\name{planning}
\alias{planning}
\title{Plan a Statistical Audit Sample}
\usage{
planning(materiality = NULL, min.precision = NULL, expected = 0,
         likelihood = c('poisson', 'binomial', 'hypergeometric'),
         conf.level = 0.95, N.units = NULL, by = 1, max = 5000,
         prior = FALSE)
}
\arguments{
\item{materiality}{a numeric value between 0 and 1 specifying the performance materiality (i.e., maximum upper limit) as a fraction of the total population size. Can be \code{NULL}, but \code{min.precision} should be specified in that case.}

\item{min.precision}{a numeric value between 0 and 1 specifying the minimum precision (i.e., upper bound minus most likely error) as a fraction of the total population size. Can be \code{NULL}, but \code{materiality} should be specified in that case.}

\item{expected}{a numeric value between 0 and 1 specifying the expected errors in the sample relative to the total sample size, or a number (>= 1) that represents the number of expected errors in the sample. It is advised to set this value conservatively to minimize the probability of the observed errors exceeding the expected errors, which would imply that insufficient work has been done in the end.}

\item{likelihood}{a character specifying the likelihood assumed in the calculation. This can be either \code{poisson} (default) for the Poisson likelihood, \code{binomial} for the binomial likelihood, or \code{hypergeometric} for the hypergeometric likelihood. See the details section for more information about the available likelihoods.}

\item{conf.level}{a numeric value between 0 and 1 specifying the confidence level used in the planning. Defaults to 0.95 for 95\% confidence.}

\item{N.units}{an integer larger than 0 specifying the total number of units or items in the population (i.e., the population size). Only required when \code{likelihood = 'hypergeometric'}.}

\item{by}{an integer larger than 0 specifying the desired increment for the sample size calculation.}

\item{max}{an integer larger than 0 specifying the maximum sample size that is considered in the calculation. Defaults to 5000 for efficiency. Increase this value if the sample size cannot be found due to it being too large (e.g., for a low materiality).}

\item{prior}{a logical specifying whether to use a prior distribution when planning, or an object of class \code{jfaPrior} or \code{jfaPosterior} containing the prior distribution. Defaults to \code{FALSE} for frequentist planning. If \code{TRUE}, a minimal information prior is chosen by default. Chooses a conjugate gamma distribution for the Poisson likelihood, a conjugate beta distribution for the binomial likelihood, and a conjugate beta-binomial distribution for the hypergeometric likelihood.}
}
\value{
An object of class \code{jfaPlanning} containing:

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level used.}
\item{x}{a numeric value larger than, or equal to, 0 indicating the number of tolerable errors in the sample.}
\item{n}{an integer larger than 0 indicating the required sample size.}
\item{ub}{a numeric value between 0 and 1 indicating the expected upper bound if the sample goes according to plan.}
\item{precision}{a numeric value between 0 and 1 indicating the expected precision if the sample goes according to plan.}
\item{p.value}{a numeric value indicating the one-sided p-value.}
\item{K}{if \code{likelihood = 'hypergeometric'}, an integer larger than 0 indicating the assumed population errors.}
\item{N.units}{an integer larger than 0 indicating the population size (only returned if \code{N} is specified).}
\item{materiality}{a numeric value between 0 and 1 indicating the specified materiality.}
\item{min.precision}{a numeric value between 0 and 1 indicating the minimum precision to be obtained.}
\item{expected}{a numeric value larger than, or equal to, 0 indicating the expected errors input.}
\item{likelihood}{a character indicating the specified likelihood.}
\item{errorType}{a character indicating whether the expected errors where specified as a percentage or as an integer.}
\item{iterations}{a numeric value indicating the number of iterations used.}
\item{prior}{if a prior distribution is specified, an object of class \code{jfaPrior} that contains information about the prior distribution.}
\item{posterior}{if a prior distribution is specified, an object of class \code{jfaPosterior} that contains information about the expected posterior distribution.}
}
\description{
This function calculates the minimum sample size for a statistical audit sample based on the Poisson, binomial, or hypergeometric likelihood. The function returns an object of class \code{jfaPlanning} which can be used with associated \code{summary()} and \code{plot()} methods.

For more details on how to use this function, see the package vignette:
\code{vignette('jfa', package = 'jfa')}
}
\details{
This section elaborates on the available likelihoods and corresponding prior distributions for the \code{likelihood} argument.

\itemize{
 \item{\code{poisson}:          The Poisson likelihood is often used as a likelihood for monetary unit sampling (MUS). The likelihood function is defined as: \deqn{p(x) = \frac{\lambda^x e^{-\lambda}}{x!}} The conjugate \emph{gamma(\eqn{\alpha, \beta})} prior has probability density function: \deqn{f(x; \alpha, \beta) = \frac{\beta^\alpha x^{\alpha - 1} e^{-\beta x}}{\Gamma(\alpha)}}}
 \item{\code{binomial}:         The binomial likelihood is often used as a likelihood for attributes sampling \emph{with} replacement. The likelihood function is defined as: \deqn{p(x) = {n \choose k} p^k (1 - p)^{n - k}} The conjugate \emph{beta(\eqn{\alpha, \beta})} prior has probability density function: \deqn{f(x; \alpha, \beta) = \frac{1}{B(\alpha, \beta)} x^{\alpha - 1} (1 - x)^{\beta - 1}}}
 \item{\code{hypergeometric}:   The hypergeometric likelihood is used as a likelihood for sampling \emph{without} replacement. The likelihood function is defined as: \deqn{p(x = k) = \frac{{K \choose k} {N - K \choose n - k}}{{N \choose n}}} The conjugate \emph{beta-binomial(\eqn{\alpha, \beta})} prior (Dyer and Pierce, 1993) has probability density function: \deqn{f(k | n, \alpha, \beta) = {n \choose k} \frac{B(k + \alpha, n - k + \beta)}{B(\alpha, \beta)}} }
}
}
\examples{
# Classical planning using a Poisson likelihood
planning(materiality = 0.05, expected = 0.025, likelihood = "poisson")

# Bayesian planning using a noninformative gamma prior distribution
planning(
  materiality = 0.05, expected = 0.025, likelihood = "poisson",
  prior = TRUE
)

# Bayesian planning using an informed gamma prior distribution
planning(
  materiality = 0.05, expected = 0.025, likelihood = "poisson",
  prior = auditPrior(method = "impartial", materiality = 0.05)
)
}
\references{
Derks, K., de Swart, J., van Batenburg, P., Wagenmakers, E.-J., & Wetzels, R. (2021). Priors in a Bayesian audit: How integration of existing information into the prior distribution can improve audit transparency and efficiency. \emph{International Journal of Auditing}, 25(3), 621-636.

Dyer, D. and Pierce, R.L. (1993). On the choice of the prior distribution in hypergeometric sampling. \emph{Communications in Statistics - Theory and Methods}, 22(8), 2125 - 2146.
}
\seealso{
\code{\link{auditPrior}} \code{\link{selection}} \code{\link{evaluation}} \code{\link{report}}
}
\author{
Koen Derks, \email{k.derks@nyenrode.nl}
}
\keyword{audit}
\keyword{planning}
\keyword{sample}
\keyword{size}
