% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jfa_methods.R
\name{jfa-methods}
\alias{jfa-methods}
\alias{print.jfaPrior}
\alias{print.jfaPosterior}
\alias{print.jfaPlanning}
\alias{print.jfaSelection}
\alias{print.jfaEvaluation}
\alias{print.summary.jfaPrior}
\alias{print.summary.jfaPosterior}
\alias{print.summary.jfaPlanning}
\alias{print.summary.jfaSelection}
\alias{print.summary.jfaEvaluation}
\alias{summary.jfaPrior}
\alias{summary.jfaPosterior}
\alias{summary.jfaPlanning}
\alias{summary.jfaSelection}
\alias{summary.jfaEvaluation}
\alias{plot.jfaPrior}
\alias{plot.jfaPosterior}
\alias{plot.jfaPlanning}
\alias{plot.jfaSelection}
\alias{plot.jfaEvaluation}
\title{Methods for jfa objects}
\usage{
\method{print}{jfaPrior}(x, ...)

\method{print}{jfaPosterior}(x, ...)

\method{print}{jfaPlanning}(x, ...)

\method{print}{jfaSelection}(x, ...)

\method{print}{jfaEvaluation}(x, ...)

\method{print}{summary.jfaPrior}(x, ...)

\method{print}{summary.jfaPosterior}(x, ...)

\method{print}{summary.jfaPlanning}(x, ...)

\method{print}{summary.jfaSelection}(x, ...)

\method{print}{summary.jfaEvaluation}(x, ...)

\method{summary}{jfaPrior}(object, digits = 3, ...)

\method{summary}{jfaPosterior}(object, digits = 3, ...)

\method{summary}{jfaPlanning}(object, digits = 3, ...)

\method{summary}{jfaSelection}(object, digits = 3, ...)

\method{summary}{jfaEvaluation}(object, digits = 3, ...)

\method{plot}{jfaPrior}(x, xmax = 0.5, ...)

\method{plot}{jfaPosterior}(x, xmax = 0.5, ...)

\method{plot}{jfaPlanning}(x, xmax = 0.5, ...)

\method{plot}{jfaSelection}(x, ...)

\method{plot}{jfaEvaluation}(x, xmax = 0.5, ...)
}
\arguments{
\item{...}{further arguments, currently ignored.}

\item{object, x}{an object of class \code{jfaPrior}, \code{jfaPosterior}, \code{jfaPlanning}, \code{jfaSelection}, or \code{jfaEvaluation}.}

\item{digits}{an integer specifying the number of digits to which output should be rounded. Used in \code{summary}.}

\item{xmax}{a number between 0 and 1 specifying the x-axis limits of the plot. Used in \code{plot}.}
}
\value{
The \code{summary} methods return a \code{data.frame} which contains the input and output.

The \code{print} methods simply print and return nothing.
}
\description{
Methods defined for objects returned from the \code{\link{auditPrior}}, \code{\link{planning}}, \code{\link{selection}}, and \code{\link{evaluation}} functions.
}
