% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{chisq.test}
\alias{chisq.test}
\alias{chisq.test.default}
\alias{chisq.test.tabyl}
\title{Apply stats::chisq.test to a two-way tabyl}
\usage{
chisq.test(x, ...)

\method{chisq.test}{default}(x, y = NULL, ...)

\method{chisq.test}{tabyl}(x, tabyl_results = TRUE, ...)
}
\arguments{
\item{x}{a two-way tabyl, a numeric vector or a factor}

\item{...}{other parameters passed to stats::chisq.test}

\item{y}{if x is a vector, must be another vector or factor of the same length}

\item{tabyl_results}{if TRUE and x is a tabyl object, also return `observed`, `expected`, `residuals` and `stdres` as tabyl}
}
\value{
The result is the same as the one of stats::chisqt.test. If `tabyl_results` 
is TRUE, the returned tables `observed`, `expected`, `residuals` and `stdres` 
are converted to tabyls.
}
\description{
This generic function overrides stats::chisq.test. If the passed table 
is a two-way tabyl, it runs it through janitor::chisq.test.tabyl, otherwise
it just calls stats::chisq.test.
}
\examples{
tab <- tabyl(mtcars, gear, cyl)
chisq.test(tab)
chisq.test(tab)$residuals

}
