% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{warpRamp}
\alias{warpRamp}
\title{Warp colors in a color ramp}
\usage{
warpRamp(
  ramp,
  lens = 5,
  divergent = TRUE,
  expandFactor = 10,
  plot = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{ramp}{character vector of R colors}

\item{lens}{numeric lens factor, centered at zero, where positive
values cause colors to change more rapidly near zero, and
negative values cause colors to change less rapidly near zero
and more rapidly near the extreme.}

\item{divergent}{logical indicating whether the \code{ramp} represents
divergent colors, which are assumed to be symmetric above and
below zero. Otherwise, colors are assumed to begin at zero.}

\item{expandFactor}{numeric factor used to expand the color ramp
prior to selecting the nearest warped numeric value as the
result of \code{warpAroundZero()}. This value should not
need to be changed unless the lens is extremely high (>100).}

\item{plot}{logical indicating whether to plot the input and
output color ramps using \code{showColors()}.}

\item{verbose}{logical indicating whether to print verbose output.}

\item{...}{additional parameters are passed to \code{showColors()}.}
}
\value{
\code{character} vector of R colors, with the same length as the
input vector \code{ramp}.
}
\description{
Warp colors in a color ramp
}
\details{
This function takes a vector of colors in a color ramp (color gradient)
and warps the gradient using a lens factor. The effect causes the
color gradient to change faster or slower, dependent upon the lens
factor.

The main intent is for heatmap color ramps, where the color gradient
changes are not consistent with meaningful numeric differences
being shown in the heatmap. In short, this function enhances
colors.
}
\examples{
BuRd <- rev(RColorBrewer::brewer.pal(11, "RdBu"));
BuRdPlus5 <- warpRamp(BuRd, lens=2, plot=TRUE);
BuRdMinus5 <- warpRamp(BuRd, lens=-2, plot=TRUE);

Reds <- RColorBrewer::brewer.pal(9, "Reds");
RedsL <- lapply(nameVector(c(-10,-5,-2,0,2,5,10)), function(lens){
   warpRamp(Reds, lens=lens, divergent=FALSE)
});
showColors(RedsL);

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()}
}
\concept{jam color functions}
