% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-plots.r
\name{smoothScatterJam}
\alias{smoothScatterJam}
\title{Smooth scatter plot, Jam style}
\usage{
smoothScatterJam(
  x,
  y = NULL,
  nbin = 256,
  bandwidth,
  colramp = grDevices::colorRampPalette(c("white", "lightblue", "blue", "orange",
    "orangered2")),
  nrpoints = 100,
  pch = ".",
  cex = 1,
  col = "black",
  transformation = function(x) x^0.25,
  postPlotHook = graphics::box,
  xlab = NULL,
  ylab = NULL,
  xlim,
  ylim,
  add = FALSE,
  xaxs = graphics::par("xaxs"),
  yaxs = graphics::par("yaxs"),
  xaxt = graphics::par("xaxt"),
  yaxt = graphics::par("yaxt"),
  useRaster = NULL,
  ...
)
}
\arguments{
\item{x}{\code{numeric} vector, or data matrix with two or  more columns.}

\item{y}{\code{numeric} vector, or if data is supplied via x as a matrix, y
is NULL.}

\item{nbin}{\code{integer} number of bins to use when converting the kernel
density result (which uses bandwidthN above) into a usable image.
For example, nbin=123 is the default used by
\code{graphics::smoothScatter()}, however the
\code{plotSmoothScatter()} function default is higher (256).}

\item{bandwidth}{\code{numeric} vector used to define the y- and x-axis
bandwidths, respectively, passed to \code{KernSmooth::bkde2D()},
which calculates the underlying 2-dimensional kernel density.
The \code{plotSmoothScatter()} function was motivated by never wanting
to define this number directly, instead auto-calculation suitable
values.}

\item{colramp}{\code{function} that takes one \code{numeric} argument and returns
that integer number of colors, by default 256.}

\item{nrpoints}{\code{integer} number of outlier datapoints to display,
as defined by \code{graphics::smoothScatter()}, however the default here
is \code{nrpoints=0} to avoid additional clutter in the output,
and because the default argument \code{bandwidthN} usually indicates all
individual points.}

\item{pch}{\code{integer} point shape used when \code{nrpoints>0}.}

\item{cex}{\code{numeric} point size expansion factor used when \code{nrpoints>0}.}

\item{col}{\code{character} R color used when \code{nrpoints>0}.}

\item{transformation}{\code{function} which converts point density to a number,
typically related to square root or cube root transformation.}

\item{postPlotHook}{\code{function} or \code{NULL}, NULL default.
When \code{function} is supplied, it is called after producing the image.
By default it is simply used to draw a box around the image,
but could be used to layer additional information atop the image plot,
for example contours, labels, etc.}

\item{xlab}{\code{character} x-axis label}

\item{ylab}{\code{character} y-axis label}

\item{xlim}{\code{numeric} x-axis range for the plot}

\item{ylim}{\code{numeric} y-axis range for the plot}

\item{add}{\code{logical} whether to add to an existing active R plot, or create
a new plot window.}

\item{xaxs}{\code{character} value compatible with \code{graphics::par("xaxs")}, mainly useful
for suppressing the x-axis, in order to produce a custom x-axis
range, most useful to restrict the axis range expansion done by R
by default.}

\item{yaxs}{\code{character} value compatible with \code{graphics::par("yaxs")}, mainly useful
for suppressing the y-axis, in order to produce a custom y-axis
range, most useful to restrict the axis range expansion done by R
by default.}

\item{xaxt}{\code{character} value compatible with \code{graphics::par("xaxt")}, mainly useful
for suppressing the x-axis, in order to produce a custom x-axis
by other mechanisms, e.g. log-scaled x-axis tick marks.}

\item{yaxt}{\code{character} value compatible with \code{graphics::par("yaxt")}, mainly useful
for suppressing the y-axis, in order to produce a custom y-axis
by other mechanisms, e.g. log-scaled y-axis tick marks.}

\item{useRaster}{\code{NULL} or \code{logical} indicating whether to invoke
\code{graphics::rasterImage()} to produce a raster image.
If NULL, it determines whether to produce a raster image within the
\code{imageDefault()} function, which checks the options
using \code{getOption("preferRaster", FALSE)} to determine among
other things, whether the user prefers raster images, and if the
\code{grDevices::dev.capabilities()} supports raster.}

\item{...}{additional arguments are passed to \code{imageDefault()} and
optionally to \code{plotPlotHook()} when supplied.}
}
\value{
\code{list} of elements sufficient to call \code{graphics::image()},
also by default this function is called for the byproduct of
creating a figure.
}
\description{
Produce smooth scatter plot, a helper function called by
\code{plotSmoothScatter()}.
}
\details{
For general purposes, use \code{plotSmoothScatter()} as a replacement
for \code{graphics::smoothScatter()}, which produces better default
settings for pixel size and density bandwidth.

This function is only necessary in order to override the
\code{graphics::smoothScatter()} function which calls
\code{graphics::image.default()}.
Instead, this function calls \code{imageDefault()} which is required
in order to utilize custom raster image scaling, particularly important
when the x- and y-axis ranges are not similar, e.g. where the x-axis spans
10 units, but the y-axis spans 10,000 units.
}
\examples{
x1 <- rnorm(1000);
y1 <- (x1 + 5)* 4  + rnorm(1000);
smoothScatterJam(x=x1, y=y1, bandwidth=c(0.05, 0.3))

}
\seealso{
\code{graphics::smoothScatter()}

Other jam internal functions: 
\code{\link{handleArgsText}()},
\code{\link{jamCalcDensity}()},
\code{\link{make_html_styles}()},
\code{\link{make_styles}()}
}
\concept{jam internal functions}
