% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-printdebug.R
\name{printDebug}
\alias{printDebug}
\alias{printDebugI}
\alias{printDebugHtml}
\title{print colorized output to R console}
\usage{
printDebug(
  ...,
  fgText = NULL,
  fgDefault = getOption("jam.fgDefault", c("darkorange1", "dodgerblue")),
  bgText = NULL,
  fgTime = getOption("jam.fgTime", "cyan2"),
  timeStamp = getOption("jam.timeStamp", TRUE),
  comment = getOption("jam.comment", !htmlOut),
  formatNumbers = getOption("jam.formatNumbers", TRUE),
  trim = getOption("jam.trim", TRUE),
  digits = getOption("jam.digits"),
  nsmall = getOption("jam.nsmall", 0L),
  justify = "left",
  big.mark = getOption("jam.big.mark", ","),
  small.mark = getOption("jam.small.mark", "."),
  zero.print = NULL,
  width = NULL,
  doColor = getOption("jam.doColor"),
  splitComments = FALSE,
  collapse = getOption("jam.collapse", ""),
  sep = getOption("jam.sep", ","),
  doReset = NULL,
  detectColors = TRUE,
  dex = 2,
  darkFactor = c(1, 1.5),
  sFactor = c(1, 1.5),
  lightMode = checkLightMode(),
  Crange = getOption("jam.Crange"),
  Lrange = getOption("jam.Lrange"),
  removeNA = FALSE,
  replaceNULL = NULL,
  adjustRgb = getOption("jam.adjustRgb"),
  byLine = FALSE,
  verbose = FALSE,
  indent = "",
  keepNA = TRUE,
  file = getOption("jam.file", ""),
  append = getOption("jam.append", TRUE),
  invert = getOption("jam.invert", FALSE),
  htmlOut = getOption("jam.htmlOut", FALSE)
)

printDebugI(..., invert = TRUE)

printDebugHtml(..., htmlOut = TRUE, comment = FALSE)
}
\arguments{
\item{...}{\code{character}, \code{factor}, \code{numeric} or compatible atomic vectors
to be printed to the R console. These arguments are recognized as
any un-named argument, or any argument whose name does not match the
named arguments below.}

\item{fgText}{one of two formats to define the foreground color for
elements in \code{...} being printed. Each element is colored in order,
and when multiple vector values are contained in one \code{...} element,
the color defined in \code{fgText} is extended.
The input types recognized:
\itemize{
\item \code{NULL} when no color is defined, one of two outputs:
\enumerate{
\item When all values in \code{...} represent colors, these colors are
used to colorize the output text. When \code{names()} are present
they are used as the text labels in place of the vector value.
\item When not all values in \code{...} represent colors, the default
color set is used: \code{c("darkorange1", "dodgerblue")}.
\item To disable option 1 above, define a specific value for \code{fgText},
such as \code{fgText=c("darkorange1", "dodgerblue")}.
}
\item \code{vector} of R compatible colors, recycled to the length of \code{...}.
When any element of \code{...} is a vector with multiple values, the
corresponding color in \code{fgText} is shaded slightly lighter and
darker, then recycled to the vector length, so that adjacent values
have slightly different color.
This behavior is controlled by default argument \code{splitComments=TRUE}.
\item \code{list} of vectors of R compatible colors, recycled to the length
of \code{...}, then applied to each element in \code{...} in order. When only
one color is defined, and multiple values are present in the
corresponding \code{list} element, the color is shaded slightly lighter
and darker, then recycled to the vector length, as described above.
This behavior is controlled by default argument \code{splitComments=TRUE}.
When multiple colors are defined for the \code{list} element, these
values are recycled to the vector length.
\item \strong{Note}: When \code{invert=TRUE} the values for \code{fgText} and \code{bgText} are
reversed, and if the resulting \code{fgText} is \code{NULL} then its color
is defined by \code{setTextContrastColor()} in order to define a contrasting
text color.
}}

\item{fgDefault}{\code{character} defaults to
\code{getOption("jam.fgDefault", c("darkorange1", "dodgerblue"))}, and
is used when colors are not defined by \code{fgText} or by the
input \code{...} values.}

\item{bgText}{\code{vector} of R colors, or \code{list} of vectors, used to define
the background color, using the same approach described for \code{fgText}.
Note that \code{NULL} or \code{NA} defines the absence of any background color,
which is default. When \code{invert=TRUE}, which is default for
\code{printDebugI()}, the values for \code{fgText} and \code{bgText} are reversed.}

\item{fgTime}{\code{character} R color to colorize the time}

\item{timeStamp}{\code{logical} whether to include a time stamp in output}

\item{comment}{\code{logical} whether to prefix output with '## ' as a comment,
or \code{character} string used as a prefix.}

\item{formatNumbers}{\code{logical} whether to format numbers using
\code{format()} which controls the number of digits displayed, and is
default. When \code{formatNumbers=FALSE} sometimes \code{numeric} values
that contain \code{integers} may be represented as \code{14.0000000001}.}

\item{trim, digits, nsmall, justify, big.mark, small.mark, zero.print, width}{arguments passed to \code{format()}.}

\item{doColor}{\code{logical} or \code{NULL} indicating whether to colorize output.
When \code{doColor} is \code{NULL}, if the \code{"crayon"} package is available,
and if crayon detects color is permitted, color is enabled.}

\item{splitComments}{\code{logical} whether to color each element independently
without light-dark alternating pattern. The intensity of the
adjustment is controlled by \code{dex} passed to \code{color2gradient()}.}

\item{collapse}{\code{character} collapse string used to separate list items,
by default "" so text separation is expected in the input data.}

\item{sep}{\code{character} separator used to separate vector elements, when
a list items contains a vector.}

\item{doReset}{\code{logical} or \code{NULL}, indicating whether to apply
\code{crayon::reset()} to the delimiter \code{sep}. When \code{doReset=TRUE} the
style on the delimiter is forced to reset, using \code{crayon::reset()},
or to remove pre-existing style with \code{crayon::strip_style()}. When
\code{doReset=NULL} and \code{sep} contains ANSI escape characters, they are
left as-is; when \code{doReset=NULL} and \code{sep} does not contain ANSI escape
characters, \code{sep} becomes \code{crayon::reset(sep)} which forces the style
to be reset between printed values.}

\item{detectColors}{\code{logical} whether to detect and potentially try to
correct console color capabilities.}

\item{dex}{\code{numeric} passed to \code{color2gradient()} to split a color
into a lighter,darker alternating pattern. Until version 0.0.83.900,
this process used \code{gradientWtFactor=1} and was not adjustable.
Note that when \code{splitComments=TRUE} the input values in \code{...}
are flattened to a single vector, and colors in \code{fgText} are
applied directly without adjustment.}

\item{darkFactor, sFactor}{\code{numeric} arguments deprecated.}

\item{lightMode}{\code{logical} or NULL, indicating whether the text
background color is light, where \code{lightMode=TRUE} indicates the
background is white or light enough to require darker text,
imposing a maximum brightness for colors displayed.
When \code{NULL} it calls \code{checkLightMode()}, which uses:
\itemize{
\item \code{getOption("jam.lightMode")} if defined
\item otherwise attempts to detect whether the session is running inside
RStudio, by checking for environmental variable \code{"RSTUDIO"},
under the assumption that default RStudio uses a light background,
therefore \code{lightMode=TRUE}.
\item if steps above fail, it uses \code{lightMode=FALSE}.
\item to force a specific lightMode for all uses, use options:
\code{options(jam.lightMode=TRUE)} or \code{options(jam.lightMode=FALSE)}.
}}

\item{Crange, Lrange}{\code{numeric} range of chroma and luminance values
between 0 and 100. When NULL, default values are assigned
by \code{setCLranges()}. The intent is to restrict the range relative
to the console background color, also controlled by \code{lightMode}.}

\item{removeNA}{\code{logical} whether to remove NA values and not print to
the console.}

\item{replaceNULL}{\code{character} or NULL, optionally replace NULL elements
with non-NULL character value, otherwise NULL elements are ignored.}

\item{adjustRgb}{\code{numeric} value adjustment used during the conversion of
RGB colors to ANSI colors, which is inherently lossy. If not defined,
it uses the default returned by \code{setCLranges()} which itself uses
\code{getOption("jam.adjustRgb")} with default=0. In order to boost
color contrast, an alternate value of -0.1 is suggested.}

\item{byLine}{\code{logical} whether to delimit lists by line instead of
using collapse to combine them onto one line.}

\item{verbose}{\code{logical} whether to print verbose output}

\item{indent}{\code{character} optional characters used as a prefix to indent
output. When \code{numeric} it is rounded to integer, then this many
character spaces \code{" "} are concatenated together to define the
indent width. Note that the \code{indent} text is not colorized.}

\item{keepNA}{\code{logical}, default TRUE, whether to keep and print NA values.}

\item{file}{argument passed to \code{cat()} to send output to a file or
compatible output of \code{cat()}.}

\item{append}{\code{logical} whether to append output, passed to \code{cat()}
when \code{file} is defined.}

\item{invert}{\code{logical} indicating whether foreground and background
colors should be switched, as is default for \code{printDebugI()}.
Note when the resulting \code{fgText} is \code{NULL}, its color is defined
by \code{setTextContrastColor()} to define a contrasting text color
relative to the background color in \code{bgText}.}

\item{htmlOut}{\code{logical} indicating whether to print HTML span
output, using format
\verb{<span style="color:fg;background-color:bg">text</span>}.
This argument is not yet implemented, more testing is required
to determine the best mechanism to use for things like 'Rmarkdown'
rendering, and R-shiny app rendering.}
}
\value{
\code{NULL} invisibly, this function is called for the side effect
of printing output using \code{cat()}.

\code{NULL} invisibly, this function is called for the side effect
of printing output using \code{cat()}.

\code{NULL} invisibly, this function is called for the side effect
of printing output using \code{cat()}.
}
\description{
print colorized output to R console

print colorized output to R console, inverted

print colorized output to HTML
}
\details{
This function prints colorized output to the R console, with some
rules for colorizing the output to help visually distinguish items.

The main intent is to use this function to print pretty debug messages,
because color helps identify.

By default, output has the following configurable properties:
\itemize{
\item each line begins with a comment, controlled by default
\code{comment=getOption("jam.comment", TRUE)} which by default uses \code{"##"},
but which can be defined to use a different prefix, or \code{FALSE}
for no prefix at all.
\item each line includes time and date stamp controlled by
\code{timeStamp=getOption("jam.timeStamp", TRUE)} which by default includes the
current time and date.
\item each line formats \code{numeric} values, controlled by
\code{formatNumbers=getOption("jam.formatNumbers", TRUE)}, which determines
whether to apply arguments \code{big.mark} and \code{small.mark} to make numeric
values more readable.
\item each entry in \code{...} is printed with its own foreground color \code{fgText},
background color \code{bgText}, with a slight lighter/darker dithering effect
to add minor visual distinction for multiple values.
\item Values in each \code{vector} are concatenated by \code{sep=","} by default.
\item Each \code{list} is concatenated by \code{collapse=""} by default.
}

Additional convenience rules:
\itemize{
\item For convenience, when the last \code{...} argument is a \code{character} vector
of colors, it is assumed to be \code{fgText}.
\item When the only entry in \code{...} is a \code{character} vector of R colors,
the names are printed using the color vector for \code{fgText}, or if no
names exist the colors are printed using the color vector for \code{fgText}.
\item For \code{printDebugI()} or \code{invert=TRUE}, colors typically assigned to
\code{fgText} are instead assigned to \code{bgText}.
\item For very specific color assignments, \code{fgText} and/or \code{bgText} can be
defined as a \code{list} of \code{character} vectors of R colors, in which case
the \code{list} overall is recycled to the length \code{...} to be printed,
and within each vector of \code{...} printed the corresponding color vector
is recycled to the length of that vector.
}

For use inside 'Rmarkdown' \code{.Rmd} documents, current recommendation is
to define the R output with \code{results='asis'} like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\\`\\`\\`\{r block_name, results='asis'\}
# some R code here
\\`\\`\\`
}\if{html}{\out{</div>}}

Then define a global option to turn off the comment prefix in
\code{printDebug()}: \code{options("jam.comment"=FALSE)}

For colorized text, it may require \code{"html_output"} rendering of the
\code{.Rmd} 'Rmarkdown' file, as well as this option to enable HTML formatting
by \code{printDebug()}: \code{options("jam.htmlOut"=TRUE)}.

This function prints colorized output to the R console, using the
same logic as \code{printDebug} except by default the color is inverted
so the default \code{fgText} colors are applied to the background.

This function prints colorized output in HTML form, using the
same logic as \code{printDebug()} except by default the output is HTML.
The intended use is for 'Rmarkdown' with chunk option \code{results='asis'},
which causes the HTML code to be interpreted directly as HTML.

This function internally calls \code{printDebug()} which then calls
\code{make_html_styles()}. The text is surrounded by \verb{<span color='#FFFFFF'>}
HTML formatting.
}
\examples{
printDebug("Testing ", "default ", "printDebug().");
printDebug("List of vectors:", c("one", "two", "three"));

# By default, there is no space between separate elements in `...`
printDebug("List of vectors:", c("one", "two", "three"),
   c("four", "five", "six"));
# To add a space " " between elements, use collapse
printDebug("List of vectors:", c("one", "two", "three"),
   c("four", "five", "six"), collapse=" ");

# slightly different style, one entry per line, indented:
printDebug("List of vectors:", c("one", "two", "three"),
   c("four", "five", "six"), collapse="\n   ");

# when a vector entirely contains recognized colors,
# the colors are used in the output
printDebug(c("red", "blue", "yellow"));

# When the vector contains colors, the names are used as the label
color_vector <- jamba::nameVector(c("red", "blue", "green","orange"),
   c("group_A", "group_B", "group_C", "group_D"));
printDebug(color_vector);

# Remember the sister function that inverses the colors
printDebugI(color_vector);

printDebug(1:10, fgText="blue", dex=2);
printDebug(1:10, bgText="blue", dex=2);
printDebug(1:10, fgText="orange", dex=2);

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}

Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}

Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
