% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{color2gradient}
\alias{color2gradient}
\title{Make a color gradient}
\usage{
color2gradient(
  col,
  n = NULL,
  gradientWtFactor = NULL,
  dex = 1,
  reverseGradient = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{col}{some type of recognized R color input as:
\itemize{
\item \code{character} vector of one or more individual colors, each
color is expanded into a gradient of length \code{n}, where \code{n} is
recycled to the number of unique colors. The value \code{n} is applied
in the order the colors appear in \code{col}.
\item \code{list} of color vectors where each vector contains one repeated color
\item \code{character} vector of repeated colors, where \code{n} is defined by
the number of each color present.
}}

\item{n}{\code{integer} vector of length one or more, which defines the number
of colors to return for each gradient. When \code{n=0} then only duplicated
colors will be expanded into a gradient.}

\item{gradientWtFactor}{\code{numeric} fraction representing the amount to expand
a color toward its maximum brightness and darkness.
It is recommended to use \code{dex} and not this argument.
\itemize{
\item When \code{gradientWtFactor=NULL} this value is calculated based upon the
number of colors requested, and the initial luminance in HCL
space of the starting color.
\item When \code{gradientWtFactor} is defined, values are recycled to
\code{length(col)}, and can be independently applied to each color.
}}

\item{dex}{\code{numeric} value to apply dramatic dark expansion, where:
\itemize{
\item \code{dex > 1} will make the gradient more dramatic, values
\item \code{dex < 1} will make the gradient less dramatic, and are considered
fractions 1/x.
\item \code{dex < 0} will make the gradient less dramatic, and values are
internally converted to fractions using \code{1/(2 + abs(dex))}
}}

\item{reverseGradient}{\code{logical} whether to return light-to-dark gradient
(TRUE) or dark-to-light gradient (FALSE).}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{...}{other parameters are ignored.}
}
\value{
\code{character} vector of R colors.
}
\description{
Make a color gradient
}
\details{
This function converts a single color into a color gradient by expanding
the initial color into lighter and darker colors around the central color.
The amount of gradient expansion is controlled by gradientWtFactor, which
is a weight factor scaled to the maximum available range of bright to
dark colors.

As an extension, the function can take a vector of colors, and expand each
into its own color gradient, each with its own number of colors.
If a vector with supplied that contains repeated colors, these colors
are expanded in-place into a gradient, bypassing the value for \code{n}.

If a list is supplied, a list is returned of the same length, where
each vector inside the list is a color gradient of length specified
by \code{n}. If the input list contains multiple values, only the first
color is used to define the color gradient.
}
\examples{
# given a list, it returns a list
x <- color2gradient(list(Reds=c("red"), Blues=c("blue")), n=c(4,7));
showColors(x);

# given a vector, it returns a vector
xv <- color2gradient(c(red="red", blue="blue"), n=c(4,7));
showColors(xv);

# Expand colors in place
# This process is similar to color jittering
colors1 <- c("red","blue")[c(1,1,2,2,1,2,1,1)];
names(colors1) <- colors1;
colors2 <- color2gradient(colors1);
showColors(list(`Input colors`=colors1, `Output colors`=colors2));

# You can do the same using a list intermediate
colors1L <- split(colors1, colors1);
showColors(colors1L);
colors2L <- color2gradient(colors1L);
showColors(colors2L);

# comparison of fixed gradientWtFactor with dynamic gradientWtFactor
showColors(list(
   `dynamic\ngradientWtFactor\ndex=1`=color2gradient(
      c("yellow", "navy", "firebrick", "orange"),
      n=3,
      gradientWtFactor=NULL,
      dex=1),
   `dynamic\ngradientWtFactor\ndex=2`=color2gradient(
      c("yellow", "navy", "firebrick", "orange"),
      n=3,
      gradientWtFactor=NULL,
      dex=2),
   `fixed\ngradientWtFactor=2/3`=color2gradient(
      c("yellow", "navy", "firebrick", "orange"),
      n=3,
      gradientWtFactor=2/3,
      dex=1)
))

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
