% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{breaksByVector}
\alias{breaksByVector}
\title{break a vector into groups}
\usage{
breaksByVector(x, labels = NULL, returnFractions = FALSE, ...)
}
\arguments{
\item{x}{\code{character} vector of labels}

\item{labels}{\code{character} vector of custom labels to represent the items
in x}

\item{returnFractions}{\code{logical} whether to return fractional coordinates
for labels that should be positioned between two labels}

\item{...}{additional parameters are ignored.}
}
\value{
\code{list} with the following named elements:
\itemize{
\item \code{"breakPoints"}: The mid-point coordinate between each break.
These midpoints would be good for drawing dividing lines for
example.
\item \code{"labelPoints"}: The ideal point to place a label to represent
the group.
\item \code{"newLabels"}: A vector of labels the same length as the input
data, except using blank values except where a label should
be drawn. This output is good for text display.
\item \code{"useLabels"}: The unique set of labels, without blanks,
corresponding to the coordinates supplied by labelPoints.
\item \code{"breakLengths"}: The integer size of each set of labels.
}
}
\description{
breaks a vector into groups
}
\details{
This function takes a vector of values, determines "chunks" of identical
values, from which it defines where breaks occur. It assumes the input
vector is ordered in the way it will be displayed, with some labels
being duplicated consecutively. This function defines the breakpoints
where the labels change, and returns the ideal position to put a single
label to represent a duplicated consecutive set of labels.

It can return fractional coordinates, for example when a label represents
two consecutive items, the fractional coordinate can be used to place the
label between the two items.

This function is useful for things like adding labels to
\code{imageDefault()} color image map of sample groupings, where
it may be ideal to label only unique elements in a contiguous set.
}
\examples{
b <- rep(LETTERS[c(1:5, 1)], c(2,3,5,4,3,4));
bb <- breaksByVector(b);
# Example showing how labels can be minimized inside a data.frame
data.frame(b,
   newLabels=bb$newLabels);

# Example showing how to reposition text labels
# so duplicated labels are displayed in the middle
# of each group
bb2 <- breaksByVector(b, returnFractions=TRUE);
ylabs <- c("minimal labels", "all labels");
withr::with_par(adjustAxisLabelMargins(ylabs, 2), {
   withr::local_par(adjustAxisLabelMargins(bb2$useLabels, 1))
   nullPlot(xlim=range(seq_along(b)), ylim=c(0,3),
      doBoxes=FALSE, doUsrBox=TRUE);
   graphics::axis(2, las=2, at=c(1,2), ylabs);
   graphics::text(y=2, x=seq_along(b), b);
   graphics::text(y=1, x=bb2$labelPoints, bb2$useLabels);

## Print axis labels in the center of each group
graphics::axis(3,
   las=2,
   at=bb2$labelPoints,
   labels=bb2$useLabels);

## indicate each region
for (i in seq_along(bb2$breakPoints)) {
   graphics::axis(1,
      at=c(c(0, bb2$breakPoints)[i]+0.8, bb2$breakPoints[i]+0.2),
      labels=c("", ""));
}
## place the label centered in each region without adding tick marks
graphics::axis(1,
   las=2,
   tick=FALSE,
   at=bb2$labelPoints,
   labels=bb2$useLabels);
## abline to indicate the boundaries, if needed
graphics::abline(v=c(0, bb2$breakPoints) + 0.5,
   lty="dashed",
   col="blue");

})
# The same process is used by imageByColors()

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
