% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_iv.R
\name{ivregFun}
\alias{ivregFun}
\title{User estimator ivreg for getsFun() and isat()}
\usage{
ivregFun(y, x, z, formula, tests, fast = FALSE)
}
\arguments{
\item{y}{A numeric vector with no missing values.}

\item{x}{A matrix or \code{NULL}.}

\item{z}{A numeric vector or matrix.}

\item{formula}{A formula in the format \code{y ~ x1 + x2 | z1 + z2}.}

\item{tests}{A logical value whether to calculate the
\code{\link[ivreg:ivregMethods]{ivreg::summary.ivreg()}} diagnostics.}

\item{fast}{A logical value whether to speed up the 2SLS estimation but
providing less details. Requires \code{tests == FALSE}.}
}
\value{
A list with entries needed for model selection via \code{\link[gets:getsFun]{gets::getsFun()}}
or \code{\link[gets:isat]{gets::isat()}}.
}
\description{
\code{ivregFun} calls \code{\link[ivreg:ivreg]{ivreg::ivreg()}} in a format that is suitable for the
model selection function \code{\link[gets:getsFun]{gets::getsFun()}} and for the indicator saturation
function \code{\link[gets:isat]{gets::isat()}}.
}
\details{
For the required outputs of user-specified estimators, see the
article "User-Specified General-to-Specific and Indicator Saturation
Methods" by Genaro Sucarrat, published in the R Journal:
\url{https://journal.r-project.org/archive/2021/RJ-2021-024/index.html}
}
