% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{new_formula}
\alias{new_formula}
\title{Takes ivreg formula and returns formula compatible with model selection}
\usage{
new_formula(formula, data, keep_exog)
}
\arguments{
\item{formula}{A formula for the \link[ivreg:ivreg]{ivreg::ivreg} function, i.e. in format
\code{y ~ x1 + x2 | z1 + z2}.}

\item{data}{A data frame.}

\item{keep_exog}{A numeric vector of indices or a character vector of names
corresponding to the exogenous regressors in the \code{data} that should not
be selected over. Default \code{NULL} means that selection is over all
exogenous regressors. If an intercept has been specified in the
\code{formula} but is not already included in the \code{data}, then it can be
kept by either including the index \code{0} or the character
\code{"Intercept"}, respectively, as an element in \code{keep_exog}.}
}
\value{
A list with several named elements. Component \code{$fml} stores the
new baseline formula that will be used for model selection. Components
\code{y}, \code{x}, and \code{z} store the data of the dependent variable,
structural regressors, and excluded instruments. The entries
\code{$depvar}, \code{$x1}, \code{$x2}, \code{$z1}, and \code{$z2} contain
the names of the dependent variable, endogenous and exogenous regressors,
included and excluded instruments. \code{$dx1}, \code{$dx2}, \code{$dz1},
\code{$dz2} store the dimensions of the respective variables. Finally,
\code{$keep} and \code{$keep.names} contain the indices and names of the
regressors that will not be selected over.
}
\description{
\code{new_formula} takes a formula object for \code{\link[ivreg:ivreg]{ivreg::ivreg()}}, i.e. in a
format of \code{y ~ x1 + x2 | x1 + z2}, and returns a list with element
suitable for model selection. For example, it updates the data by creating
an intercept if specified in the formula, checks for collinearity among the
regressors, and updates the formula accordingly.
}
