% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotSurface.R
\name{plotsurface}
\alias{plotsurface}
\title{Creates a colored surface plot.}
\usage{
plotsurface(data, view, predictor = NULL, valCI = NULL, main = NULL,
  xlab = NULL, ylab = NULL, xlim = NULL, ylim = NULL, zlim = NULL,
  col = NULL, color = topo.colors(50), ci.col = c("red", "green"),
  nCol = 50, add.color.legend = TRUE, ...)
}
\arguments{
\item{data}{Data frame or list with plot data. A data frame needs to have a
column with x values, a column with y values and a column with z values. A
list contains a vector with unique x values, a vector with unique y values,
and a matrix with z-values. The output of the function fvisgam is an
example of a suitable list.}

\item{view}{A vector with the names or numbers of the columns to plot on
the x axis and y axis respectively.}

\item{predictor}{Optional: the name of the column in the data frame
\code{data} that provides the z-values. If data contains more than one
column besides the x- and y-values, the \code{predictor} should be provided.}

\item{valCI}{Optional: the name of the column in the data frame
\code{data} that provides the CI-values. If not NULL, CI contour lines
will be plotted.}

\item{main}{Text string, an overall title for the plot.}

\item{xlab}{Label for x axis. Default is name of first \code{view} variable.}

\item{ylab}{Label for y axis. Default is name of second \code{view}
variable.}

\item{xlim}{x-limits for the plot.}

\item{ylim}{y-limits for the plot.}

\item{zlim}{z-limits for the plot.}

\item{col}{Color for the  contour lines and labels.}

\item{color}{a list of colors such as that generated by
\code{\link[grDevices]{rainbow}}, \code{\link[grDevices]{heat.colors}}
\code{\link[grDevices]{colors}}, \code{\link[grDevices]{topo.colors}},
\code{\link[grDevices]{terrain.colors}} or similar functions.}

\item{ci.col}{Two-value vector with colors for the lower CI contour lines
and for the upper CI contour lines.}

\item{nCol}{The number of colors to use in color schemes.}

\item{add.color.legend}{Logical: whether or not to add a color legend.
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link{gradientLegend}} to add a legend manually at any position.}

\item{...}{Optional parameters for \code{\link[graphics]{image}}
and \code{\link[graphics]{contour}}.}
}
\description{
This function is a wrapper around \code{\link[graphics]{image}}
and \code{\link[graphics]{contour}}. See \code{vignette("plotfunctions")}
for an example of how you could use \code{\link[graphics]{image}} and
\code{\link[graphics]{contour}}.
}
\examples{
data(simdat)

\dontrun{
# Model with interaction:
m1 <- bam(Y ~ s(Time) + s(Trial)
+ti(Time, Trial),
data=simdat)

# get partial prediction of the ti-term:
pp <- get_modelterm(m1, select=3, as.data.frame=TRUE)
head(pp)

# plot surface:
plotsurface(pp, view=c('Time', "Trial"), predictor='fit')
# ...is the same as:
pvisgam(m1,view=c('Time', "Trial"), select=3)

# add main effects of Time and Trial:
pp1  <- get_modelterm(m1, select=1, as.data.frame=TRUE)
pp2  <- get_modelterm(m1, select=2, as.data.frame=TRUE)
pp$fit.sum <- pp$fit + rep(pp1$fit, 30) + rep(pp2$fit, each=30)

plotsurface(pp, view=c('Time', "Trial"), predictor='fit.sum')
# ...is not same as fvisgam, because in previous plot the intercept
# is not included:
fvisgam(m1, view=c('Time', "Trial"))

# This is same as fvisgam:
pp <- get_predictions(m1, cond=list(Time=seq(0,2000, length=30),
	Trial=seq(-10,10,length=30)))
plotsurface(pp, view=c('Time', "Trial"), predictor='fit', valCI='CI')

# Just contour plot:
plotsurface(pp, view=c('Time', "Trial"), predictor='fit', valCI='CI',
	main='contour',	color=NULL, col=1, add.color.legend=FALSE)
}
}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[graphics]{image}}, \code{\link[graphics]{contour}},
\code{\link{color_contour}}

Other functions for model predictions: \code{\link{get_coefs}};
  \code{\link{get_difference}};
  \code{\link{get_modelterm}};
  \code{\link{get_predictions}}; \code{\link{get_random}};
  \code{\link{inspect_random}}
}

