% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predictions.R
\name{get_difference}
\alias{get_difference}
\title{Get model predictions for differences between conditions.}
\usage{
get_difference(model, cond1, cond2, cond = NULL, se = TRUE, f = 1.96,
  print.summary = TRUE)
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{cond1}{A named list with the values to use for the first difference
condition.}

\item{cond2}{A named list with the values to use for the second difference
condition.}

\item{cond}{A named list of the values to use for the other predictor
terms. Variables omitted from this list will have the closest observed
value to the median for continuous variables, or the reference level for
factors.}

\item{se}{Logical: whether or not to return the confidence interval or
standard error around the estimates.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting
in 95\% confidence intervals. For 99\% confidence intervals use a value of
2.58.}

\item{print.summary}{Logical: whether or not to print a summary of the
values selected for each predictor. Defaults to TRUE.}
}
\value{
Returns a data frame with the estimates of the difference and
optionally the confidence intervals around that estimate.
}
\description{
Get model predictions for differences between conditions.
}
\examples{
data(simdat)

# first fit a simple model:
m1 <- bam(Y ~ Group+te(Time, Trial, by=Group), data=simdat)

# get difference estimates:
diff <- get_difference(m1, cond1=list(Group='Adults'),
cond2=list(Group='Children'), cond=list(Time=seq(0,500,length=100)))
head(diff)
}
\author{
Jacolien van Rij, Martijn Wieling
}
\seealso{
Other functions for model predictions: \code{\link{get_modelterm}};
  \code{\link{get_predictions}}; \code{\link{get_random}}
}

