% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/inspect_residuals.R
\name{check_normaldist}
\alias{check_normaldist}
\title{Compare distribution of data with normal distribution.}
\usage{
check_normaldist(res, col = "red", col.normal = "black",
  legend.pos = "topright", legend.label = "data", ...)
}
\arguments{
\item{res}{Vector with residuals or other data for which the distribution .}

\item{col}{Color for filling the area. Default is black.}

\item{col.normal}{Color for shading and line of normal distribution.}

\item{legend.pos}{Position of legend, can be string (e.g., 'topleft') or an
\code{\link[grDevices]{xy.coords}} object.}

\item{legend.label}{Text string, label for plotted data distribution.}

\item{...}{Optional arguments for the lines. See \code{\link{par}}.}
}
\description{
Compare distribution of data with normal distribution.
}
\section{Note}{

Assumes centered data as input.
}
\examples{
set.seed(123)
# normal distribution:
test <- rnorm(1000)
check_normaldist(test)
# t-distribution:
test <- rt(1000, df=5)
check_normaldist(test)
# skewed data, e.g., reaction times:
test <- exp(rnorm(1000, mean=.500, sd=.25))
check_normaldist(test)
# center first:
check_normaldist(scale(test))
}
\author{
Jacolien van Rij
}
\seealso{
Other functions for model criticism: \code{\link{acf_n_plots}};
  \code{\link{acf_plot}}; \code{\link{acf_resid}};
  \code{\link{resid.gam}}, \code{\link{resid_gam}}
}

