% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{iter_wrapper}
\alias{iter_wrapper}
\title{Wrap iterpc objects by iterators::iter}
\usage{
iter_wrapper(I, d = 1)
}
\arguments{
\item{I}{the iterpc object}

\item{d}{number of permutation(s)/combination(s) wanted in each iteration, default to 1}
}
\value{
a iter object compatible with iterators package
}
\description{
Wrap iterpc objects by iterators::iter
}
\examples{
library(iterators)
I <- iterpc(5, 2)
it <- iter_wrapper(I)
nextElem(it)
nextElem(it)

library(foreach)
I <- iterpc(5, 2)
it <- iter_wrapper(I)
foreach(x=it, .combine=c) \%do\% { sum(x) }
}
