% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{iso_make_units_explicit}
\alias{iso_make_units_explicit}
\title{Make units explicit}
\usage{
iso_make_units_explicit(df, prefix = " [", suffix = "]")
}
\arguments{
\item{df}{the data frame in which to make the units explicit}

\item{prefix}{the prefix for the units}

\item{suffix}{the suffix for the units}
}
\description{
This function is intended for data frames / tibbles only and makes the units of columns that have numbers with units explicit in the column name. It also strips the units attribute from those columns using \code{\link{iso_strip_units}}. The reverse function is \code{\link{iso_make_units_implicit}}.
}
\examples{
# a data frame with implicit units
df <- tibble(peak = 1:5, height = iso_double_with_units(1:5, "V"))
df

# show with explicit units
iso_make_units_explicit(df)

# show with explicit units (custom prefix & suffix)
iso_make_units_explicit(df, prefix = ".", suffix = "")
}
\seealso{
Other functions for values with units: 
\code{\link{iso_get_units}()},
\code{\link{iso_is_double_with_units}()},
\code{\link{iso_make_units_implicit}()},
\code{\link{iso_strip_units}()},
\code{\link{iso_with_units}()}
}
\concept{functions for values with units}
