\name{irtProb-package}
\alias{irtProb-package}
\alias{irtProb}
\docType{package}
\title{ Utilities and Probability Distributions Related to Multidimensional Person Item Response Models (IRT)}


\description{
 The \code{irtProb} package was mainly developped to compute probability distributions
 in the context of Item Response Theory (IRT). Actually two families of models are taken into account.
 The first is the family of 1, 2, 3 and 4 parameters logistic fonctions. The second is a
 new logistic family adding of 1, 2, 3 and 4 person parameters. With \code{irtProb} some utilitarian
 functions are also available. So it is possible to generate response patterns with each family of
 item response models and other functions are also available to do conversion of item parameters
 between classical test theory and item response theory (2PL). Maximum likelihood and Maximum a
 posteriori estimation function of the multidimensional person paramaters are also available.
 }


\details{
 \tabular{ll}{
  Package: \tab irtProb\cr
  Type: \tab Package\cr
  Version: \tab 1.0\cr
  Date: \tab 2007-08-28\cr
  Depends: \tab R (>= 2.0.0), lattice, methods, moments\cr
  License: \tab GPL\cr
  LazyLoad: \tab yes\cr
  }
 }

\author{
 Gilles Raiche, Universite du Quebec a Montreal (UQAM),

 Departement d'education et pedagogie
 
 \email{Raiche.Gilles@uqam.ca}, \url{http://www.er.uqam.ca/nobel/r17165/}
 }


\references{
 Bartholomew, D. J., Steele, F., Moustaki, I. and Galbraith, J. I. (2000).
 \emph{The analysis and interpretation of multivariate data for social scientists}. Boca Raton, California: Chapman and Hall.

 Carroll, J. B. (1945). The effect of difficulty and chance success on correlations between items or between tests.
 \emph{Psychometrika, 10}(1), 1-19.

 Freund, J. E. and Wallpole, R. E. (1980). \emph{Mathematical statistics, 3rd edition}. Englewood Cliffs, New Jersey: Prentice-Hall.

 Guilford, J. P. (1936). The determination of item difficulty when chance success is a factor. \emph{Psychometrika, 1}(4), 259-264.

 Guilford, J. P. (1954). \emph{Psychometric methods, 2d edition}. New York, New jersey: McGraw-Hill.

 Hambleton, R. K. and Swaminathan, H. (1985). \emph{Item response theory - Principles and applications}. Boston, Massachuset: Kluwer.

 Lord, F. M. (1944). Reliability of multiple-choice tests as a function of number of choice per item. \emph{Journal of educational psychology, 35}(3), 175-180.

 Lord, F. M. (1980). \emph{Applications of item response theory to practical testing problems}. Mahwah, New Jersey: Lawrence Erlbaum Associates.

 Lord, F. M. and Novick, M. R. (1968). \emph{Statistical theories of mental test scores, 2nd edition}. Reading, Massacusett: Addison-Wesley.

 Plumlee, L B. (1952). The effect of difficulty and chance success on item-test correlations and on test reliability. \emph{Psychometrika, 17}(1), 69-86.

 Plumlee, L B. (1954). The predicted and observed effect of chance success on multiple-choice test validity. \emph{Psychometrika, 19}(1), 65-70.
 }

\seealso{
 Other packages are also very useful to manipulate IRT objects. The R psychometric view is instructive at this point.
 See \url{http://cran.stat.sfu.ca/web/views/Psychometrics.html} for further details.
 }

\keyword{ package }



