% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readParameters.R
\name{readParameters}
\alias{readParameters}
\title{Reads the parameters to be tuned by \pkg{irace} from a file or from a
character string.}
\usage{
readParameters(file, digits = 4L, debugLevel = 0L, text)
}
\arguments{
\item{file}{\code{character(1)}\cr Filename containing the definitions of
the parameters to be tuned.}

\item{digits}{\code{integer(1)}\cr The number of decimal places to be considered for real-valued parameters.}

\item{debugLevel}{\code{integer(1)}\cr Larger values produce more verbose output.}

\item{text}{\code{character(1)}\cr If \code{file} is not supplied and this is,
then parameters are read from the value of \code{text} via a text connection.}
}
\value{
A list containing the definitions of the parameters read. The list is
structured as follows:
\describe{
\item{\code{names}}{Vector that contains the names of the parameters.}
\item{\code{types}}{Vector that contains the type of each parameter 'i', 'c', 'r', 'o'.
Numerical parameters can be sampled in a log-scale with 'i,log' and 'r,log'
(no spaces).}
\item{\code{switches}}{Vector that contains the switches to be used for the
parameters on the command line.}
\item{\code{domain}}{List of vectors, where each vector may contain two
values (minimum, maximum) for real and integer parameters, or
possibly more for categorical parameters.}
\item{\code{conditions}}{List of R logical expressions, with variables
corresponding to parameter names.}
\item{\code{isFixed}}{Logical vector that specifies which parameter is fixed
and, thus, it does not need to be tuned.}
\item{\code{nbParameters}}{An integer, the total number of parameters.}
\item{\code{nbFixed}}{An integer, the number of parameters with a fixed value.}
\item{\code{nbVariable}}{Number of variable (to be tuned) parameters.}
\item{\code{depends}}{List of character vectors, each vector specifies
which parameters depend on this one.}
\item{\code{is_dependent}}{Logical vector that specifies which parameter has
a dependent domain.}
\item{\code{digits}}{Integer vector that specifies the number of digits per parameter.}
\item{\code{forbidden}}{List of expressions that define which parameter configurations are forbidden.}
}
}
\description{
Reads the parameters to be tuned by \pkg{irace} from a file or from a
character string.
}
\details{
Either \code{file} or \code{text} must be given. If \code{file} is given, the
parameters are read from the file \code{file}. If \code{text} is given instead,
the parameters are read directly from the \code{text} character string.
In both cases, the parameters must be given (in \code{text} or in the file
whose name is \code{file}) in the expected form.  See the documentation
for details.  If none of these parameters is given, \pkg{irace}
will stop with an error.

A fixed parameter is a parameter that should not be sampled but
instead should be always set to the only value of its domain.  In this
function we set \code{isFixed} to TRUE only if the parameter is a categorical
and has only one possible value.  If it is an integer and the minimum
and maximum are equal, or it is a real and the minimum and maximum
values satisfy \code{round(minimum, digits) == round(maximum, digits)},
then the parameter description is rejected as invalid to identify
potential user errors.

The order of the parameters determines the order in which parameters are
given to \code{targetRunner}. Changing the order may also change the results
produced by \code{irace}, even with the same random seed.
}
\examples{
 ## Read the parameters directly from text
 parameters_table <- '
 # name       switch           type  values               [conditions (using R syntax)]
 algorithm    "--"             c     (as,mmas,eas,ras,acs)
 localsearch  "--localsearch " o     (0, 1, 2, 3)
 alpha        "--alpha "       r     (0.00, 5.00)
 beta         "--beta "        r     (0.00, 10.00)
 rho          "--rho  "        r     (0.01, 1.00)
 ants         "--ants "        i,log (5, 100)
 q0           "--q0 "          r     (0.0, 1.0)           | algorithm == "acs"
 rasrank      "--rasranks "    i     (1, "min(ants, 10)") | algorithm == "ras"
 elitistants  "--elitistants " i     (1, ants)            | algorithm == "eas"
 nnls         "--nnls "        i     (5, 50)              | localsearch \%in\% c(1,2,3)
 dlb          "--dlb "         c     (0, 1)               | localsearch \%in\% c(1,2,3)
 
 [forbidden]
 (alpha == 0.0) & (beta == 0.0)
 [global]
 digits = 4
 '
 parameters <- readParameters(text=parameters_table)
 str(parameters)

}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
