% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{separate_rows.ir}
\alias{separate_rows.ir}
\title{Separate a collapsed column in an \code{ir} object into multiple rows}
\source{
\code{\link[tidyr:separate_rows]{tidyr::separate_rows()}}
}
\usage{
separate_rows.ir(data, ..., sep = "[^[:alnum:].]+", convert = FALSE)
}
\arguments{
\item{data}{An object of class \code{ir}.}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to separate across
multiple rows}

\item{sep}{Separator delimiting collapsed values.}

\item{convert}{If \code{TRUE} will automatically run
\code{\link[=type.convert]{type.convert()}} on the key column. This is useful if the column
types are actually numeric, integer, or logical.}
}
\value{
\code{data} with a collapsed column separated into multiple rows. See
\code{\link[tidyr:separate_rows]{tidyr::separate_rows()}}.
}
\description{
Separate a collapsed column in an \code{ir} object into multiple rows
}
\examples{
## separate_rows
ir_sample_data \%>\%
  tidyr::unite(
    col = content, holocellulose, klason_lignin
  ) \%>\%
  tidyr::separate_rows(
    col
  )


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate-joins}},
\code{\link{mutate}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
